/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbbackups.api;

import java.nio.file.Path;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

public interface IArchivalPlugin {
    public ResourceLocation getId();

    default public String getFileExtension() {
        return this.getId().getPath();
    }

    @ApiStatus.OverrideOnly
    public long createArchive(ArchivalContext var1) throws Exception;

    @ApiStatus.OverrideOnly
    public void restoreArchive(RestorationContext var1) throws Exception;

    @ApiStatus.NonExtendable
    default public String addFileExtension(String fileName) {
        return this.getFileExtension().isEmpty() ? fileName : fileName + "." + this.getFileExtension();
    }

    @ApiStatus.NonExtendable
    public static interface RestorationContext
    extends Context {
        public Path destinationFolder();
    }

    @ApiStatus.NonExtendable
    public static interface ArchivalContext
    extends Context {
        public Map<Path, String> manifest();

        public int compressionLevel();
    }

    @ApiStatus.NonExtendable
    public static interface Context {
        public Logger logger();

        public Path archivePath();

        public void notifyProcessingFile(String var1);
    }
}

