/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbbackups.client;

import dev.ftb.mods.ftbbackups.Backups;
import dev.ftb.mods.ftbbackups.FTBBackups;
import dev.ftb.mods.ftbbackups.client.BackupOverlayLayer;
import dev.ftb.mods.ftbbackups.client.RestoreBackupScreen;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="ftbbackups3", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class BackupsClient {
    private static BackupProgress backupProgress = BackupProgress.NONE;
    private static int progressTicker = 0;
    private static boolean disabledOnServer = false;

    public static void onModConstruction() {
        NeoForge.EVENT_BUS.addListener(BackupsClient::onClientDisconnected);
        NeoForge.EVENT_BUS.addListener(BackupsClient::addRestoreButton);
        NeoForge.EVENT_BUS.addListener(BackupsClient::clientTick);
    }

    private static void clientTick(ClientTickEvent.Post event) {
        if (progressTicker > 0 && --progressTicker == 0) {
            backupProgress = BackupProgress.NONE;
        }
    }

    private static void addRestoreButton(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof SelectWorldScreen) {
            SelectWorldScreen s = (SelectWorldScreen)screen;
            Backups backups = Backups.getClientInstance();
            if (!backups.backups().isEmpty()) {
                MutableComponent btnLabel = Component.translatable((String)"ftbbackups3.gui.restore").append("...");
                MutableComponent title = Component.translatable((String)"ftbbackups3.gui.restore");
                int w = s.getMinecraft().font.width((FormattedText)btnLabel) + 20;
                event.addListener((GuiEventListener)Button.builder((Component)btnLabel, arg_0 -> BackupsClient.lambda$addRestoreButton$0(s, (Component)title, arg_0)).bounds(s.width - w - 10, 22, w, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"ftbbackups3.gui.restore.tooltip"))).build());
            }
        }
    }

    @SubscribeEvent
    public static void registerGuiLayer(RegisterGuiLayersEvent event) {
        if (!FTBBackups.isDisabledByEnvironmentVar()) {
            event.registerAboveAll(BackupOverlayLayer.ID, (LayeredDraw.Layer)new BackupOverlayLayer());
        }
    }

    public static void setBackupProgress(int current, int total) {
        backupProgress = new BackupProgress(current, total);
        if (backupProgress.finished()) {
            progressTicker = 40;
        }
    }

    private static void onClientDisconnected(ClientPlayerNetworkEvent.LoggingOut ignoredEvent) {
        backupProgress = BackupProgress.NONE;
        BackupsClient.setDisabledOnThisServer(false);
    }

    @NotNull
    public static MutableComponent progressMessage() {
        return Component.translatable((String)"ftbbackups3.lang.timer_progress", (Object[])new Object[]{backupProgress.current() * 100 / backupProgress.total(), backupProgress.current(), backupProgress.total()});
    }

    public static BackupProgress getBackupProgress() {
        return backupProgress;
    }

    public static void setDisabledOnThisServer(boolean disabled) {
        disabledOnServer = disabled;
        SidebarButtonManager.INSTANCE.getButton(FTBBackups.id("config")).ifPresent(btn -> btn.setForceHidden(disabled));
    }

    public static boolean isDisabledOnThisServer() {
        return disabledOnServer;
    }

    private static /* synthetic */ void lambda$addRestoreButton$0(SelectWorldScreen s, Component title, Button b) {
        Minecraft.getInstance().setScreen((Screen)new RestoreBackupScreen((Screen)s, title));
    }

    public record BackupProgress(int current, int total) {
        public static final BackupProgress NONE = new BackupProgress(0, 0);

        public boolean inProgress() {
            return this.total > 0;
        }

        public boolean finished() {
            return this.current == this.total;
        }
    }
}

