/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei.wrapper;

import com.google.common.collect.Lists;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.integration.jei.IRecipeHelper;
import fr.frinn.custommachinery.common.guielement.SlotGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.LootTableHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class LootTableIngredientWrapper
implements IJEIIngredientWrapper<ItemStack> {
    private final ResourceLocation lootTable;

    public LootTableIngredientWrapper(ResourceLocation lootTable) {
        this.lootTable = lootTable;
    }

    @Override
    public boolean setupRecipe(IRecipeLayoutBuilder builder, int xOffset, int yOffset, IGuiElement element, IRecipeHelper helper) {
        SlotGuiElement slotElement;
        block5: {
            block4: {
                if (!(element instanceof SlotGuiElement)) break block4;
                slotElement = (SlotGuiElement)element;
                if (element.getType() == Registration.SLOT_GUI_ELEMENT.get()) break block5;
            }
            return false;
        }
        List<LootTableHelper.LootData> loots = LootTableHelper.getLootsForTable(this.lootTable);
        ArrayList ingredients = Lists.newArrayList(loots.stream().map(LootTableHelper.LootData::stack).toList());
        Optional<IMachineComponentTemplate<?>> template = helper.getComponentForElement(slotElement);
        if (template.map(t -> t.canAccept(ingredients, false, helper.getDummyManager())).orElse(false).booleanValue()) {
            int slotX = element.getX() + (element.getWidth() - 16) / 2;
            int slotY = element.getY() + (element.getHeight() - 16) / 2;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, slotX - xOffset, slotY - yOffset).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, (List)ingredients)).addRichTooltipCallback((view, tooltips) -> {
                LootTableHelper.LootData data = view.getDisplayedIngredient().flatMap(ingredient -> loots.stream().filter(lootData -> ItemStack.isSameItemSameComponents((ItemStack)lootData.stack(), (ItemStack)((ItemStack)ingredient.getItemStack().get()))).findFirst()).orElse(null);
                if (data == null) {
                    return;
                }
                if (data.chance() != 1.0) {
                    double percentage = data.chance() * 100.0;
                    if (percentage < (double)0.01f) {
                        tooltips.add((FormattedText)Component.translatable((String)"custommachinery.jei.ingredient.chance", (Object[])new Object[]{"<0.01"}));
                    } else {
                        BigDecimal decimal = BigDecimal.valueOf(percentage).setScale(2, RoundingMode.HALF_UP);
                        if (decimal.scale() <= 0 || decimal.signum() == 0 || decimal.stripTrailingZeros().scale() <= 0) {
                            tooltips.add((FormattedText)Component.translatable((String)"custommachinery.jei.ingredient.chance", (Object[])new Object[]{decimal.intValue()}));
                        } else {
                            tooltips.add((FormattedText)Component.translatable((String)"custommachinery.jei.ingredient.chance", (Object[])new Object[]{decimal.doubleValue()}));
                        }
                    }
                    if (!data.rolls().isEmpty()) {
                        tooltips.add((FormattedText)Component.literal((String)data.rolls()));
                    }
                    if (!data.bonusRolls().isEmpty()) {
                        tooltips.add((FormattedText)Component.literal((String)data.bonusRolls()));
                    }
                }
            });
            return true;
        }
        return false;
    }
}

