/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListWidget<E extends Entry>
extends AbstractWidget
implements ContainerEventHandler {
    private final int itemHeight;
    private final List<E> entries = new ArrayList();
    private final Minecraft mc = Minecraft.getInstance();
    private final Font font;
    @Nullable
    private E selected;
    private boolean renderSelection;
    private double scrollAmount;
    private boolean scrolling;
    private boolean dragging;

    public ListWidget(int x, int y, int width, int height, int itemHeight, Component message) {
        super(x, y, width, height, message);
        this.font = this.mc.font;
        this.renderSelection = false;
        this.itemHeight = itemHeight;
    }

    public List<E> getEntries() {
        return ImmutableList.copyOf(this.entries);
    }

    public void addEntry(E entry) {
        this.entries.add(entry);
    }

    public void sort(Comparator<E> comparator) {
        this.entries.sort(comparator);
    }

    public void clear() {
        this.entries.clear();
        this.selected = null;
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable E selected) {
        this.selected = selected;
        if (selected != null) {
            this.ensureVisible(selected);
        }
    }

    @Nullable
    public E getEntryAtPosition(double mouseX, double mouseY) {
        int index = Mth.clamp((int)Mth.floor((double)(mouseY - (double)this.getY() + this.getScrollAmount() - 4.0)), (int)0, (int)this.getMaxPosition()) / this.itemHeight;
        if (mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.width) && index >= 0 && index < this.entries.size()) {
            return (E)((Entry)this.entries.get(index));
        }
        return null;
    }

    @NotNull
    public List<E> children() {
        return this.getEntries();
    }

    public int getMaxPosition() {
        return this.entries.size() * this.itemHeight;
    }

    private void scroll(int scroll) {
        this.setScrollAmount(this.getScrollAmount() + (double)scroll);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double scroll) {
        this.scrollAmount = Mth.clamp((double)scroll, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - this.height + 4);
    }

    public void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPosition() && mouseX < (double)(this.getScrollbarPosition() + 6);
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.width - 6;
    }

    public void ensureVisible(E entry) {
        int k;
        int entryTop = this.getY() + 4 - (int)this.getScrollAmount() + this.entries.indexOf(entry) * this.itemHeight;
        int j = entryTop - this.getY() - 4 - this.itemHeight;
        if (j < 0) {
            this.scroll(j);
        }
        if ((k = this.getY() + this.height - entryTop - this.itemHeight * 2) < 0) {
            this.scroll(-k);
        }
    }

    protected void setRenderSelection() {
        this.renderSelection = true;
    }

    protected void renderList(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        for (int index = 0; index < this.entries.size(); ++index) {
            int entryTop = this.getY() + 4 - (int)this.getScrollAmount() + index * this.itemHeight;
            int entryBottom = entryTop + this.itemHeight;
            if (entryBottom < this.getY() || entryTop > this.getY() + this.height) continue;
            this.renderItem(graphics, mouseX, mouseY, partialTick, index, this.getX(), entryTop, this.width, this.itemHeight - 4);
        }
    }

    protected void renderItem(GuiGraphics graphics, int mouseX, int mouseY, float partialTick, int index, int left, int top, int width, int height) {
        Entry entry = (Entry)this.entries.get(index);
        entry.renderBackground(graphics, index, left, top, width, height, mouseX, mouseY, partialTick);
        if (this.renderSelection && this.selected == entry) {
            this.renderSelection(graphics, top, width - 8, height, FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)0), FastColor.ARGB32.color((int)255, (int)198, (int)198, (int)198));
        }
        entry.render(graphics, index, left, top, width, height, mouseX, mouseY, partialTick);
        for (Object children : entry.children()) {
            if (!(children instanceof Renderable)) continue;
            Renderable renderable = (Renderable)children;
            renderable.render(graphics, mouseX, mouseY, partialTick);
        }
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int barLeft = this.getScrollbarPosition();
        int barRight = barLeft + 6;
        graphics.enableScissor(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height);
        this.renderList(graphics, mouseX, mouseY, partialTick);
        graphics.disableScissor();
        if (this.getMaxScroll() > 0) {
            int n = (int)((float)(this.height * this.height) / (float)this.getMaxPosition());
            n = Mth.clamp((int)n, (int)32, (int)(this.height - 8));
            int o = (int)this.getScrollAmount() * (this.height - n) / this.getMaxScroll() + this.getY();
            if (o < this.getY()) {
                o = this.getY();
            }
            graphics.fill(barLeft, this.getY(), barRight, this.getY() + this.height, -16777216);
            graphics.fill(barLeft, o, barRight, o + n, -8355712);
            graphics.fill(barLeft, o, barRight - 1, o + n - 1, -4144960);
        }
        RenderSystem.disableBlend();
    }

    protected void renderSelection(GuiGraphics guiGraphics, int top, int width, int height, int outerColor, int innerColor) {
        guiGraphics.fill(this.getX(), top - 2, this.getX() + width, top + height + 2, outerColor);
        guiGraphics.fill(this.getX() + 1, top - 1, this.getX() + width - 1, top + height + 1, innerColor);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (this.getFocused() != null && this.getFocused().mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        E entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry != null) {
            GuiEventListener focused = this.getFocused();
            if (focused != entry && focused instanceof ContainerEventHandler) {
                ContainerEventHandler container = (ContainerEventHandler)focused;
                container.setFocused(null);
            }
            entry.mouseClicked(mouseX, mouseY, button);
            this.setFocused((GuiEventListener)entry);
            this.setDragging(true);
            return true;
        }
        return this.scrolling;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.getFocused() != null) {
            this.getFocused().mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        if (this.getFocused() != null) {
            this.getFocused().mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        if (button != 0 || !this.scrolling) {
            return false;
        }
        if (mouseY < (double)this.getY()) {
            this.setScrollAmount(0.0);
        } else if (mouseY > (double)(this.getY() + this.height)) {
            this.setScrollAmount(this.getMaxScroll());
        } else {
            double d = Math.max(1, this.getMaxScroll());
            int i = this.height;
            int j = Mth.clamp((int)((int)((float)(i * i) / (float)this.getMaxPosition())), (int)32, (int)(i - 8));
            double e = Math.max(1.0, d / (double)(i - j));
            this.setScrollAmount(this.getScrollAmount() + dragY * e);
        }
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.getFocused() != null && this.getFocused().mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        this.setScrollAmount(this.getScrollAmount() - scrollY * (double)this.itemHeight / 2.0);
        return true;
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        if (this.entries.isEmpty()) {
            return null;
        }
        if (event instanceof FocusNavigationEvent.ArrowNavigation) {
            FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)event;
            if (arrowNavigation.direction().getAxis() == ScreenAxis.HORIZONTAL) {
                if (this.selected != null) {
                    return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)((Entry)this.selected).nextFocusPath(event));
                }
                return null;
            }
            if (arrowNavigation.direction() == ScreenDirection.DOWN) {
                if (this.selected != null) {
                    if (this.entries.indexOf(this.selected) == this.entries.size() - 1) {
                        return null;
                    }
                    return this.entryPath((Entry)this.entries.get(this.entries.indexOf(this.selected) + 1), arrowNavigation);
                }
                return this.entryPath((Entry)this.entries.getFirst(), arrowNavigation);
            }
            if (arrowNavigation.direction() == ScreenDirection.UP) {
                if (this.selected != null) {
                    if (this.entries.indexOf(this.selected) == 0) {
                        return null;
                    }
                    return this.entryPath((Entry)this.entries.get(this.entries.indexOf(this.selected) - 1), arrowNavigation);
                }
                return this.entryPath((Entry)this.entries.getLast(), arrowNavigation);
            }
        }
        return super.nextFocusPath(event);
    }

    private ComponentPath entryPath(E entry, FocusNavigationEvent.ArrowNavigation event) {
        ComponentPath entryPath = ((Entry)entry).focusPathAtIndex((FocusNavigationEvent)event, event.direction() == ScreenDirection.UP ? Integer.MAX_VALUE : 0);
        if (entryPath == null) {
            return ComponentPath.path(entry, (ContainerEventHandler[])new ContainerEventHandler[]{this});
        }
        return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)entryPath);
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        int i = this.entries.indexOf(focused);
        if (i >= 0) {
            Entry entry = (Entry)this.entries.get(i);
            this.setSelected(entry);
            if (this.mc.getLastInputType().isKeyboard()) {
                this.ensureVisible(entry);
            }
            entry.setFocused(true);
        } else {
            this.setSelected(null);
        }
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.selected;
    }

    public void setDragging(boolean isDragging) {
        this.dragging = isDragging;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public static abstract class Entry
    implements ContainerEventHandler {
        @Nullable
        private GuiEventListener focused;
        private boolean dragging;

        protected void renderBackground(GuiGraphics graphics, int index, int x, int y, int width, int height, int mouseX, int mouseY, float partialTicks) {
        }

        protected abstract void render(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, float var9);

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return this.getFocused() != null && this.getFocused().mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public boolean isDragging() {
            return this.dragging;
        }

        public void setDragging(boolean isDragging) {
            this.dragging = isDragging;
        }

        @Nullable
        public GuiEventListener getFocused() {
            return this.focused;
        }

        public void setFocused(@Nullable GuiEventListener focused) {
            if (this.focused == focused) {
                return;
            }
            if (this.focused != null) {
                this.focused.setFocused(false);
            }
            if (focused != null) {
                focused.setFocused(true);
            }
            this.focused = focused;
        }

        @Nullable
        public ComponentPath focusPathAtIndex(FocusNavigationEvent event, int index) {
            if (this.children().isEmpty()) {
                return null;
            }
            ComponentPath componentPath = ((GuiEventListener)this.children().get(Math.min(index, this.children().size() - 1))).nextFocusPath(event);
            return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)componentPath);
        }

        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent event) {
            if (event instanceof FocusNavigationEvent.ArrowNavigation) {
                int i;
                FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)event;
                int n = i = arrowNavigation.direction() == ScreenDirection.RIGHT ? 1 : 0;
                if (i == 0) {
                    return null;
                }
                for (int k = Mth.clamp((int)(i + this.children().indexOf(this.getFocused())), (int)0, (int)(this.children().size() - 1)); k >= 0 && k < this.children().size(); k += i) {
                    GuiEventListener guiEventListener = (GuiEventListener)this.children().get(k);
                    ComponentPath componentPath = guiEventListener.nextFocusPath(event);
                    if (componentPath == null) continue;
                    return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)componentPath);
                }
            }
            return super.nextFocusPath(event);
        }
    }
}

