/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker.requirements;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import fr.frinn.custommachinery.api.integration.crafttweaker.RecipeCTBuilder;
import fr.frinn.custommachinery.common.requirement.DimensionRequirement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.requirement.Dimension")
public interface DimensionRequirementCT<T>
extends RecipeCTBuilder<T> {
    @ZenCodeType.Method
    default public T dimensionWhitelist(String[] dimensions) {
        try {
            List<ResourceLocation> dimensionsID = Arrays.stream(dimensions).map(ResourceLocation::parse).toList();
            return this.addRequirement(new DimensionRequirement(dimensionsID, false));
        }
        catch (ResourceLocationException e) {
            return this.error("Invalid dimension ID: {}", e.getMessage());
        }
    }

    @ZenCodeType.Method
    default public T dimensionWhitelist(String dimension) {
        try {
            return this.addRequirement(new DimensionRequirement(Collections.singletonList(ResourceLocation.parse((String)dimension)), false));
        }
        catch (ResourceLocationException e) {
            return this.error("Invalid dimension ID: {}", e.getMessage());
        }
    }

    @ZenCodeType.Method
    default public T dimensionBlacklist(String[] dimensions) {
        try {
            List<ResourceLocation> dimensionsID = Arrays.stream(dimensions).map(ResourceLocation::parse).toList();
            return this.addRequirement(new DimensionRequirement(dimensionsID, false));
        }
        catch (ResourceLocationException e) {
            return this.error("Invalid dimension ID: {}", e.getMessage());
        }
    }

    @ZenCodeType.Method
    default public T dimensionBlacklist(String dimension) {
        try {
            return this.addRequirement(new DimensionRequirement(Collections.singletonList(ResourceLocation.parse((String)dimension)), false));
        }
        catch (ResourceLocationException e) {
            return this.error("Invalid dimension ID: {}", e.getMessage());
        }
    }
}

