/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.network.SUpdateUpgradesPacket;
import fr.frinn.custommachinery.common.upgrade.MachineUpgrade;
import fr.frinn.custommachinery.common.upgrade.UpgradeLocation;
import fr.frinn.custommachinery.common.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CEditUpgradePacket(UpgradeLocation location, MachineUpgrade upgrade) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CEditUpgradePacket> TYPE = new CustomPacketPayload.Type(CustomMachinery.rl("edit_upgrade"));
    public static final StreamCodec<FriendlyByteBuf, CEditUpgradePacket> CODEC = new StreamCodec<FriendlyByteBuf, CEditUpgradePacket>(){

        public CEditUpgradePacket decode(FriendlyByteBuf buf) {
            UpgradeLocation location = UpgradeLocation.CODEC.fromNetwork(buf);
            MachineUpgrade upgrade = MachineUpgrade.CODEC.fromNetwork(buf);
            return new CEditUpgradePacket(location, upgrade);
        }

        public void encode(FriendlyByteBuf buf, CEditUpgradePacket packet) {
            UpgradeLocation.CODEC.toNetwork(packet.location, buf);
            MachineUpgrade.CODEC.toNetwork(packet.upgrade, buf);
        }
    };

    public CustomPacketPayload.Type<CEditUpgradePacket> type() {
        return TYPE;
    }

    public static void handle(CEditUpgradePacket packet, IPayloadContext context) {
        ServerPlayer player;
        Player player2 = context.player();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).hasPermissions(2)) {
            context.enqueueWork(() -> {
                FileUtils.writeUpgradeJson(player.server, packet.location, packet.upgrade);
                CustomMachinery.UPGRADES.removeUpgrade(packet.location.id());
                UpgradeLocation location = packet.location;
                try {
                    File upgradeJson = location.getFile(player.server);
                    if (upgradeJson != null && upgradeJson.exists()) {
                        BasicFileAttributes attributes = Files.getFileAttributeView(upgradeJson.toPath(), BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
                        location = UpgradeLocation.fromLoader(location.loader(), location.id(), location.packName(), attributes.creationTime(), attributes.lastModifiedTime());
                    }
                }
                catch (IOException | NullPointerException exception) {
                    // empty catch block
                }
                CustomMachinery.UPGRADES.addUpgrade(location, packet.upgrade);
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SUpdateUpgradesPacket(CustomMachinery.UPGRADES.getAllUpgrades()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            });
        }
    }
}

