/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.upgrade;

import com.mojang.datafixers.util.Pair;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.crafting.IProcessor;
import fr.frinn.custommachinery.api.upgrade.IMachineUpgradeManager;
import fr.frinn.custommachinery.api.upgrade.IRecipeModifier;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessor;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.UpgradedCustomMachine;
import fr.frinn.custommachinery.common.upgrade.ComponentModifier;
import fr.frinn.custommachinery.common.upgrade.MachineUpgrade;
import fr.frinn.custommachinery.common.upgrade.UpgradeableComponentValue;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class UpgradeManager
implements IMachineUpgradeManager {
    private final CustomMachineTile tile;
    private final List<Pair<IRecipeModifier, Integer>> activeRecipeModifiers = new ArrayList<Pair<IRecipeModifier, Integer>>();
    private final List<UpgradeableComponentValue> activeModifiedValues = new ArrayList<UpgradeableComponentValue>();
    private boolean recipeModifiersDirty = true;

    public UpgradeManager(CustomMachineTile tile) {
        this.tile = tile;
    }

    @Override
    public void refresh() {
        if (this.tile.getLevel() == null || this.tile.getLevel().isClientSide()) {
            return;
        }
        this.recipeModifiersDirty = true;
        this.refreshComponentModifiers();
    }

    private void refreshComponentModifiers() {
        ArrayList<UpgradeableComponentValue> actives = new ArrayList<UpgradeableComponentValue>(this.activeModifiedValues);
        this.activeModifiedValues.clear();
        this.getCurrentUpgrades().forEach(pair -> ((MachineUpgrade)pair.getFirst()).components().forEach(modifier -> this.tile.getComponentManager().getUpgradeableComponentValue(modifier.component(), modifier.id(), modifier.target()).ifPresent(value -> {
            actives.remove(value);
            this.activeModifiedValues.add((UpgradeableComponentValue)value);
            value.refresh((ComponentModifier)modifier, (Integer)pair.getSecond());
        })));
        actives.forEach(value -> value.refresh(null, 0));
        IProcessor iProcessor = this.tile.getProcessor();
        if (iProcessor instanceof MachineProcessor) {
            MachineProcessor machineProcessor = (MachineProcessor)iProcessor;
            machineProcessor.refreshCoreCount(this.getCurrentUpgrades().flatMap(pair -> ((MachineUpgrade)pair.getFirst()).coreModifier().stream().map(component -> Pair.of((Object)component, (Object)((Integer)pair.getSecond())))));
        }
    }

    private void refreshRecipeModifiers() {
        this.recipeModifiersDirty = false;
        this.activeRecipeModifiers.clear();
        CustomMachine customMachine = this.tile.getMachine();
        if (customMachine instanceof UpgradedCustomMachine) {
            UpgradedCustomMachine upgradedMachine = (UpgradedCustomMachine)customMachine;
            upgradedMachine.getModifiers().forEach(modifier -> this.activeRecipeModifiers.add((Pair<IRecipeModifier, Integer>)Pair.of((Object)modifier, (Object)1)));
        }
        this.activeRecipeModifiers.addAll(this.getCurrentUpgrades().flatMap(pair -> ((MachineUpgrade)pair.getFirst()).recipeModifiers().stream().map(modifier -> Pair.of((Object)modifier, (Object)((Integer)pair.getSecond())))).toList());
    }

    @Override
    public Stream<Pair<MachineUpgrade, Integer>> getCurrentUpgrades() {
        return this.tile.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).stream().flatMap(handler -> handler.getComponents().stream()).filter(slot -> slot.getType() == Registration.ITEM_UPGRADE_MACHINE_COMPONENT.get() && !slot.getItemStack().isEmpty()).flatMap(slot -> CustomMachinery.UPGRADES.getUpgradesForItemAndMachine(slot.getItemStack().getItem(), this.tile.getMachine().getId()).stream().map(upgrade -> Pair.of((Object)upgrade, (Object)Math.min(slot.getItemStack().getCount(), upgrade.max()))));
    }

    @Override
    public List<Pair<IRecipeModifier, Integer>> getRecipeModifiers() {
        if (this.recipeModifiersDirty) {
            this.refreshRecipeModifiers();
        }
        return this.activeRecipeModifiers;
    }
}

