/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class FakeItemRenderer {
    public static void render(GuiGraphics graphics, ItemStack stack, int x, int y, int color) {
        if (stack.isEmpty()) {
            return;
        }
        BakedModel bakedmodel = Minecraft.getInstance().getItemRenderer().getModel(stack, (Level)Minecraft.getInstance().level, (LivingEntity)Minecraft.getInstance().player, 42);
        graphics.pose().pushPose();
        graphics.pose().translate((float)(x + 8), (float)(y + 8), 150.0f);
        try {
            boolean flatItem;
            graphics.pose().scale(16.0f, -16.0f, 16.0f);
            boolean bl = flatItem = !bakedmodel.usesBlockLight();
            if (flatItem) {
                Lighting.setupForFlatItems();
            }
            WrappedBufferSource buffer = new WrappedBufferSource(Minecraft.getInstance().renderBuffers().bufferSource(), color);
            Minecraft.getInstance().getItemRenderer().render(stack, ItemDisplayContext.GUI, false, graphics.pose(), (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedmodel);
            buffer.end();
            if (flatItem) {
                Lighting.setupFor3DItems();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Rendering item");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Item being rendered");
            crashreportcategory.setDetail("Item Type", () -> String.valueOf(stack.getItem()));
            crashreportcategory.setDetail("Item Components", () -> String.valueOf(stack.getComponents()));
            crashreportcategory.setDetail("Item Foil", () -> String.valueOf(stack.hasFoil()));
            throw new ReportedException(crashreport);
        }
        graphics.pose().popPose();
    }

    private record WrappedBufferSource(MultiBufferSource.BufferSource wrapped, int color) implements MultiBufferSource
    {
        public VertexConsumer getBuffer(RenderType type) {
            return new WrappedVertexConsumer(this.wrapped.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)InventoryMenu.BLOCK_ATLAS)), this.color);
        }

        public void end() {
            this.wrapped.endBatch();
        }
    }

    private record WrappedVertexConsumer(VertexConsumer wrapped, int color) implements VertexConsumer
    {
        public VertexConsumer addVertex(float x, float y, float z) {
            this.wrapped.addVertex(x, y, z);
            return this;
        }

        public VertexConsumer setColor(int red, int green, int blue, int alpha) {
            this.wrapped.setColor(red * FastColor.ARGB32.red((int)this.color) / 255, green * FastColor.ARGB32.green((int)this.color) / 255, blue * FastColor.ARGB32.blue((int)this.color) / 255, alpha * FastColor.ARGB32.alpha((int)this.color) / 255);
            return this;
        }

        public VertexConsumer setUv(float u, float v) {
            this.wrapped.setUv(u, v);
            return this;
        }

        public VertexConsumer setUv1(int u, int v) {
            this.wrapped.setUv1(u, v);
            return this;
        }

        public VertexConsumer setUv2(int u, int v) {
            this.wrapped.setUv2(u, v);
            return this;
        }

        public VertexConsumer setNormal(float x, float y, float z) {
            this.wrapped.setNormal(x, y, z);
            return this;
        }
    }
}

