/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.block;

import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteambases.data.construction.BaseConstructionManager;
import dev.ftb.mods.ftbteambases.events.neoforge.TeamBasesPortalEvent;
import dev.ftb.mods.ftbteambases.net.ShowSelectionGuiMessage;
import dev.ftb.mods.ftbteambases.registry.ModBlocks;
import dev.ftb.mods.ftbteambases.registry.ModSounds;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class BasesPortalBlock
extends NetherPortalBlock {
    public BasesPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
    }

    public void entityInside(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        ServerPlayer player;
        if (level.isClientSide || !(entity instanceof ServerPlayer) || !(player = (ServerPlayer)entity).canUsePortal(false)) {
            return;
        }
        if (player.isOnPortalCooldown()) {
            player.setPortalCooldown();
        } else {
            TeamBasesPortalEvent event = (TeamBasesPortalEvent)NeoForge.EVENT_BUS.post((Event)new TeamBasesPortalEvent((Player)player));
            if (!event.isCanceled()) {
                FTBTeamsAPI.api().getManager().getTeamForPlayer(player).ifPresent(team -> {
                    if (team.isPartyTeam()) {
                        BaseInstanceManager.get(player.getServer()).teleportToBaseSpawn(player, team.getId());
                    } else if (!BaseConstructionManager.INSTANCE.isConstructing(player)) {
                        player.setPortalCooldown();
                        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)ShowSelectionGuiMessage.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                });
            } else {
                player.displayClientMessage(event.getCancellationReason(), true);
                player.setPortalCooldown();
            }
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction.Axis facing = ctx.getHorizontalDirection().getAxis();
        facing = facing == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        return (BlockState)this.defaultBlockState().setValue((Property)NetherPortalBlock.AXIS, (Comparable)facing);
    }

    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((ItemLike)ModBlocks.PORTAL_ITEM.get());
    }

    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        return blockState;
    }

    public void animateTick(BlockState blockState, Level level, BlockPos pos, RandomSource randomSource) {
        if (randomSource.nextInt(100) == 0) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, ModSounds.PORTAL.get(), SoundSource.BLOCKS, 0.5f, randomSource.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double x = (double)pos.getX() + randomSource.nextDouble();
            double y = (double)pos.getY() + randomSource.nextDouble();
            double z = (double)pos.getZ() + randomSource.nextDouble();
            double xo = ((double)randomSource.nextFloat() - 0.5) * 0.5;
            double yo = ((double)randomSource.nextFloat() - 0.5) * 0.5;
            double zo = ((double)randomSource.nextFloat() - 0.5) * 0.5;
            int k = randomSource.nextInt(2) * 2 - 1;
            if (!level.getBlockState(pos.west()).is((Block)this) && !level.getBlockState(pos.east()).is((Block)this)) {
                x = (double)pos.getX() + 0.5 + 0.25 * (double)k;
                xo = randomSource.nextFloat() * 2.0f * (float)k;
            } else {
                z = (double)pos.getZ() + 0.5 + 0.25 * (double)k;
                zo = randomSource.nextFloat() * 2.0f * (float)k;
            }
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, x, y, z, xo, yo, zo);
        }
    }
}

