/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbteambases.command.CommandUtils;
import dev.ftb.mods.ftbteambases.data.bases.ArchivedBaseDetails;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteambases.data.purging.PurgeManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class PurgeCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"purge").requires(ctx -> ctx.hasPermission(2))).then(Commands.literal((String)"id").then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> CommandUtils.suggestArchivedBases(builder)).executes(ctx -> PurgeCommand.addById((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"id")))))).then(Commands.literal((String)"older").then(Commands.argument((String)"days", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> PurgeCommand.addByAge((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"days")))))).then(Commands.literal((String)"cancel").then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> CommandUtils.suggestPendingPurges(builder)).executes(ctx -> PurgeCommand.cancelPurge((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"id")))))).then(Commands.literal((String)"cancel_all").executes(ctx -> PurgeCommand.cancelAll((CommandSourceStack)ctx.getSource())));
    }

    private static int addById(CommandSourceStack source, String ids) {
        BaseInstanceManager mgr = BaseInstanceManager.get(source.getServer());
        ArrayList<ArchivedBaseDetails> details = new ArrayList<ArchivedBaseDetails>();
        for (String id : ids.split("\\s+")) {
            mgr.getArchivedBase(id).ifPresentOrElse(details::add, () -> source.sendFailure((Component)Component.literal((String)("Unknown archived base ID " + id)).withStyle(ChatFormatting.RED)));
        }
        return PurgeCommand.schedulePurge(source, details);
    }

    private static int addByAge(CommandSourceStack source, int minDays) {
        BaseInstanceManager mgr = BaseInstanceManager.get(source.getServer());
        long now = System.currentTimeMillis();
        long delta = (long)minDays * 86400L * 1000L;
        List<ArchivedBaseDetails> details = mgr.getArchivedBases().stream().filter(base -> now - base.archiveTime() > delta).toList();
        return PurgeCommand.schedulePurge(source, details);
    }

    private static int cancelAll(CommandSourceStack source) {
        if (PurgeManager.INSTANCE.clearPending()) {
            source.sendSuccess(() -> Component.literal((String)"All pending purges cancelled"), false);
            return 1;
        }
        CommandUtils.error(source, Component.literal((String)"Failed to updated pending purge file, check server log"));
        return 0;
    }

    private static int cancelPurge(CommandSourceStack source, String id) throws CommandSyntaxException {
        if (PurgeManager.INSTANCE.removePending(id)) {
            source.sendSuccess(() -> Component.literal((String)("Cancelled purge for archived base: " + id)), false);
            return 1;
        }
        CommandUtils.error(source, Component.literal((String)"Failed to updated pending purge file, check server log"));
        return 0;
    }

    private static int schedulePurge(CommandSourceStack source, List<ArchivedBaseDetails> details) {
        if (details.isEmpty()) {
            return 0;
        }
        if (PurgeManager.INSTANCE.addPending(details)) {
            source.sendSuccess(() -> Component.literal((String)("Scheduled " + details.size() + " base(s) for permanent purge on next server restart")), false);
            source.sendSuccess(() -> Component.literal((String)"Use '/ftbteambases purge cancel_all' to cancel all pending purges"), false);
            return 1;
        }
        CommandUtils.error(source, Component.literal((String)"Can't schedule base(s) for purge"));
        return 0;
    }
}

