/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftbteambases.util.RegionFileRelocator;
import java.io.IOException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;

public class RelocateCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"relocate").requires(ctx -> ctx.hasPermission(2))).then(Commands.argument((String)"template", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"region_x", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)Commands.argument((String)"region_z", (ArgumentType)IntegerArgumentType.integer()).then(Commands.literal((String)"force").executes(ctx -> RelocateCommand.doRelocate((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"template"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"region_x"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"region_z"), true)))).executes(ctx -> RelocateCommand.doRelocate((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"template"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"region_x"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"region_z"), false)))));
    }

    private static int doRelocate(CommandSourceStack source, String templateId, int x, int z, boolean force) {
        try {
            RegionFileRelocator relocator = RegionFileRelocator.create(source, templateId, (ResourceKey<Level>)source.getLevel().dimension(), RelocateCommand::onRelocationTick, XZ.of((int)x, (int)z), force);
            relocator.start(success -> RelocateCommand.onRelocationComplete(source, relocator, x, z, success));
            source.sendSuccess(() -> Component.literal((String)"relocation started, stand by...").withStyle(ChatFormatting.YELLOW), false);
            return 1;
        }
        catch (IOException e) {
            source.sendFailure((Component)Component.literal((String)("could not start region relocation: " + e.getMessage())));
            return 0;
        }
    }

    private static void onRelocationTick(ServerPlayer player, RegionFileRelocator relocator) {
        if (player != null) {
            int pct = (int)(100.0f * relocator.getProgress());
            player.displayClientMessage((Component)Component.literal((String)("progress " + pct + "%")), true);
        }
    }

    private static void onRelocationComplete(CommandSourceStack source, RegionFileRelocator relocator, int x, int z, boolean success) {
        if (success) {
            source.sendSuccess(() -> Component.literal((String)"relocation complete! teleporting...").withStyle(ChatFormatting.GREEN), false);
            if (source.getPlayer() != null) {
                int xPos = x * 512 + 8;
                int zPos = z * 512 + 8;
                source.getLevel().getChunkAt(new BlockPos(xPos, 0, zPos));
                int y = source.getLevel().getHeight(Heightmap.Types.WORLD_SURFACE, xPos, zPos);
                source.getPlayer().teleportTo(source.getLevel(), (double)xPos, (double)y, (double)zPos, 0.0f, 0.0f);
            }
        } else {
            source.sendFailure((Component)Component.literal((String)"relocation failed, check server log").withStyle(ChatFormatting.RED));
        }
    }
}

