/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.data.construction;

import dev.ftb.mods.ftbteambases.util.RegionFileRelocator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public enum RelocatorTracker {
    INSTANCE;

    private final Map<UUID, Entry> map = new ConcurrentHashMap<UUID, Entry>();

    public RegionFileRelocator add(RegionFileRelocator relocator, Ticker ticker) {
        if (this.map.containsKey(relocator.getRelocatorId())) {
            throw new IllegalStateException("relocator id already added! " + String.valueOf(relocator.getRelocatorId()));
        }
        this.map.put(relocator.getRelocatorId(), new Entry(relocator, ticker));
        return relocator;
    }

    public void remove(RegionFileRelocator relocator) {
        this.map.remove(relocator.getRelocatorId());
    }

    public void tick(MinecraftServer server) {
        if (!this.map.isEmpty() && server.getTickCount() % 5 == 0) {
            this.map.forEach((id, entry) -> {
                if (entry.relocator().isStarted()) {
                    UUID playerId = entry.relocator().getPlayerId();
                    ServerPlayer player = playerId == null ? null : server.getPlayerList().getPlayer(playerId);
                    entry.ticker().tick(player, entry.relocator());
                }
            });
        }
    }

    private record Entry(RegionFileRelocator relocator, Ticker ticker) {
    }

    @FunctionalInterface
    public static interface Ticker {
        public void tick(@Nullable ServerPlayer var1, RegionFileRelocator var2);
    }
}

