/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.data.definition;

import dev.ftb.mods.ftbteambases.FTBTeamBases;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.structure.StructureSet;

@FunctionalInterface
public interface StructureSetProvider {
    public List<ResourceLocation> structureSetIds();

    public static Stream<Holder<StructureSet>> getStructureSets(HolderLookup<StructureSet> holderLookup, StructureSetProvider provider) {
        ArrayList<Holder> res = new ArrayList<Holder>();
        for (ResourceLocation id : provider.structureSetIds()) {
            if (id.getPath().startsWith("#")) {
                ResourceLocation tagId = ResourceLocation.tryParse((String)id.toString().substring(1));
                if (tagId == null) {
                    FTBTeamBases.LOGGER.warn("Invalid structure set tag format: {}", (Object)id);
                    continue;
                }
                TagKey tag = TagKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)tagId);
                try {
                    HolderSet.Named set = (HolderSet.Named)holderLookup.get(tag).orElseThrow();
                    set.forEach(res::add);
                }
                catch (Exception e) {
                    FTBTeamBases.LOGGER.warn("Could not resolve structure set tag: {}", (Object)tagId, (Object)e);
                }
                continue;
            }
            try {
                Holder holder = (Holder)holderLookup.get(ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)id)).orElseThrow();
                res.add(holder);
            }
            catch (Exception e) {
                FTBTeamBases.LOGGER.warn("Could not resolve structure set ID: {}", (Object)id, (Object)e);
            }
        }
        return res.stream();
    }
}

