/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.data.purging;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.data.bases.ArchivedBaseDetails;
import dev.ftb.mods.ftbteambases.util.DimensionUtils;
import dev.ftb.mods.ftbteambases.util.RegionExtents;
import dev.ftb.mods.ftbteambases.util.RegionFileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;

public record PendingPurgeData(Map<String, PurgeRecord> pending) {
    private static final Path PENDING_PATH = Path.of("ftbteambases", "pending_purge.json");
    private static final Codec<Map<String, PurgeRecord>> MAP_CODEC = Codec.unboundedMap((Codec)Codec.STRING, PurgeRecord.CODEC).xmap(HashMap::new, Map::copyOf);
    private static final Codec<PendingPurgeData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)MAP_CODEC.fieldOf("pending").forGetter(PendingPurgeData::pending)).apply((Applicative)inst, PendingPurgeData::new));

    private static PendingPurgeData empty() {
        return new PendingPurgeData(new HashMap<String, PurgeRecord>());
    }

    @NotNull
    private static Path getPendingFilePath(MinecraftServer server) {
        return server.getServerDirectory().resolve(PENDING_PATH);
    }

    public static PendingPurgeData readFromFile(MinecraftServer server) {
        PendingPurgeData pendingPurgeData;
        block9: {
            Path srcPath = PendingPurgeData.getPendingFilePath(server);
            if (!Files.exists(srcPath, new LinkOption[0])) {
                return PendingPurgeData.empty();
            }
            Stream<String> str = Files.lines(srcPath);
            try {
                JsonElement json = JsonParser.parseString((String)str.collect(Collectors.joining("\n")));
                pendingPurgeData = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(err -> FTBTeamBases.LOGGER.error("Can't parse {}: {}", (Object)PENDING_PATH, err)).orElse(PendingPurgeData.empty());
                if (str == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (str != null) {
                        try {
                            str.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    FTBTeamBases.LOGGER.error("Can't read {}: {}", (Object)PENDING_PATH, (Object)e.getMessage());
                    return PendingPurgeData.empty();
                }
            }
            str.close();
        }
        return pendingPurgeData;
    }

    boolean writeToFile(MinecraftServer server) {
        MutableBoolean res = new MutableBoolean(false);
        CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).resultOrPartial(err -> FTBTeamBases.LOGGER.error("Can't encode pending data: {}", err)).ifPresent(jsonElement -> {
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                Files.writeString(PendingPurgeData.getPendingFilePath(server), (CharSequence)gson.toJson(jsonElement), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                res.setTrue();
            }
            catch (IOException e) {
                FTBTeamBases.LOGGER.error("Can't write {}: {}", (Object)PENDING_PATH, (Object)e.getMessage());
            }
        });
        return res.booleanValue();
    }

    PendingPurgeData add(Collection<ArchivedBaseDetails> details) {
        details.forEach(a -> this.pending.put(a.archiveId(), PurgeRecord.of(a)));
        return this;
    }

    PendingPurgeData remove(Collection<ArchivedBaseDetails> details) {
        details.forEach(a -> this.pending.remove(a.archiveId()));
        return this;
    }

    public PendingPurgeData remove(String id) {
        this.pending.remove(id);
        return this;
    }

    PendingPurgeData clearPending() {
        this.pending.clear();
        return this;
    }

    record PurgeRecord(ResourceLocation dimensionId, RegionExtents extents) {
        public static final Codec<PurgeRecord> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("dimensionId").forGetter(PurgeRecord::dimensionId), (App)RegionExtents.CODEC.fieldOf("extents").forGetter(PurgeRecord::extents)).apply((Applicative)inst, PurgeRecord::new));

        private static PurgeRecord of(ArchivedBaseDetails details) {
            return new PurgeRecord(details.dimension().location(), details.extents());
        }

        void doPurge(MinecraftServer server, boolean simulate) {
            Path path = RegionFileUtil.getPathForDimension(server, (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)this.dimensionId));
            if (DimensionUtils.isPrivateTeamDimension(this.dimensionId)) {
                try {
                    if (!simulate) {
                        FileUtils.deleteDirectory((File)path.toFile());
                    }
                    FTBTeamBases.LOGGER.info("purged archived base dimension dir: {}", (Object)path);
                }
                catch (IOException e) {
                    FTBTeamBases.LOGGER.error("can't purge archived base dimension dir {}", (Object)path);
                }
            } else if (this.dimensionId.getNamespace().equals("ftbteambases")) {
                List.of("region", "entities", "poi").forEach(subDir -> this.extents.files(path.resolve((String)subDir)).forEach(file -> {
                    try {
                        if (!simulate) {
                            Files.deleteIfExists(file);
                            FTBTeamBases.LOGGER.info("purged archived base MCA file: {}", file);
                        }
                    }
                    catch (IOException e) {
                        FTBTeamBases.LOGGER.error("can't purge archived base MCA file {}", file);
                    }
                }));
            }
        }
    }
}

