/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.util;

import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.config.ServerConfig;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.commons.io.FileUtils;

public class LobbyPregen {
    private static final Path PREGEN_INITIAL_PATH = Path.of("ftbteambases", "pregen_initial");
    private static final List<Path> INITIAL_SUBDIRS = Stream.of("region", "entities", "poi", "DIM1", "DIM-1").map(x$0 -> Path.of(x$0, new String[0])).toList();

    public static boolean maybePregenLobby(MinecraftServer server) {
        ArrayList<Path> subDirs = new ArrayList<Path>(INITIAL_SUBDIRS);
        Path initialPath = server.getServerDirectory().resolve(PREGEN_INITIAL_PATH);
        Path worldPath = server.getWorldPath(LevelResource.ROOT);
        if (Files.isDirectory(initialPath, new LinkOption[0]) && !Files.isDirectory(worldPath.resolve("region"), new LinkOption[0])) {
            LobbyPregen.addExtras(subDirs);
            for (Path subDir : subDirs) {
                Path srcDir = initialPath.resolve(subDir);
                Path destDir = worldPath.resolve(subDir);
                if (!Files.isDirectory(srcDir, new LinkOption[0]) || Files.isDirectory(destDir, new LinkOption[0])) continue;
                try {
                    FileUtils.copyDirectory((File)srcDir.toFile(), (File)destDir.toFile());
                    FTBTeamBases.LOGGER.info("Copied initial pregen MCA files from {} to {}", (Object)srcDir, (Object)destDir);
                }
                catch (IOException e) {
                    FTBTeamBases.LOGGER.error("Failed to copy initial MCA files from {} to {}: {}", (Object)srcDir, (Object)destDir, (Object)e.getMessage());
                }
            }
            ServerConfig.lobbyPos().ifPresent(pos -> {
                BaseInstanceManager mgr = BaseInstanceManager.get(server);
                mgr.setLobbySpawnPos((BlockPos)pos, false);
                mgr.setLobbyCreated(true);
                mgr.forceSave(server);
            });
            return true;
        }
        return false;
    }

    private static void addExtras(List<Path> paths) {
        ServerConfig.lobbyDimension().ifPresent(key -> {
            ResourceLocation rl = key.location();
            if (!rl.getNamespace().equals("minecraft")) {
                paths.add(Path.of("dimensions", rl.getNamespace(), rl.getPath()));
            }
        });
    }
}

