/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.worldgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinitionManager;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinitionProvider;
import dev.ftb.mods.ftbteambases.registry.ModWorldGen;
import dev.ftb.mods.ftbteambases.util.DimensionUtils;
import dev.ftb.mods.ftbteambases.worldgen.structure.StartStructurePiece;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StartStructure
extends Structure {
    public static final MapCodec<StartStructure> CODEC = RecordCodecBuilder.mapCodec(x -> x.group((App)StartStructure.settingsCodec((RecordCodecBuilder.Instance)x), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(s -> s.startHeight), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(s -> s.projectStartToHeightmap)).apply((Applicative)x, StartStructure::new));
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;

    private StartStructure(Structure.StructureSettings settings, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap) {
        super(settings);
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        if (!(chunkGenerator instanceof BaseDefinitionProvider)) {
            return Optional.empty();
        }
        BaseDefinitionProvider provider = (BaseDefinitionProvider)chunkGenerator;
        BaseDefinitionManager mgr = BaseDefinitionManager.getServerInstance();
        Optional<Structure.GenerationStub> res = mgr.getBaseDefinition(provider.getBaseDefinitionId()).flatMap(baseDefinition -> baseDefinition.constructionType().prebuilt().map(prebuiltStructure -> {
            StructureTemplate template = context.structureTemplateManager().getOrCreate(prebuiltStructure.startStructure());
            BlockPos spawnPos = DimensionUtils.findSpawnBlockInStructure(template).orElse(BlockPos.ZERO);
            int x = -spawnPos.getX();
            int y = -spawnPos.getY();
            int z = -spawnPos.getZ();
            BlockPos blockPos = new BlockPos(x, y + prebuiltStructure.height(), z);
            return Optional.of(new Structure.GenerationStub(blockPos, builder -> builder.addPiece((StructurePiece)new StartStructurePiece(context.structureTemplateManager(), prebuiltStructure.startStructure(), blockPos, template))));
        }).orElse(Optional.empty()));
        if (res.isEmpty()) {
            FTBTeamBases.LOGGER.warn("Unable to find [{}] in the prebuilt structure list", (Object)provider.getBaseDefinitionId());
        }
        return res;
    }

    public StructureType<?> type() {
        return ModWorldGen.START_STRUCTURE.get();
    }
}

