/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.routers.integration;

import com.benbenlaw.routers.networking.packets.JEISyncToMenu;
import com.benbenlaw.routers.networking.packets.JEISyncToMenuChemical;
import com.benbenlaw.routers.networking.packets.JEISyncToMenuFluid;
import com.benbenlaw.routers.screen.ImporterMenu;
import com.benbenlaw.routers.screen.ImporterScreen;
import com.benbenlaw.routers.screen.util.GhostSlot;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.chemical.ChemicalStack;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class GhostIngredientImporterHandler
implements IGhostIngredientHandler<ImporterScreen> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(final ImporterScreen screen, ITypedIngredient<I> ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        for (int i = 0; i < ((ImporterMenu)screen.getMenu()).slots.size(); ++i) {
            final Slot slot = (Slot)((ImporterMenu)screen.getMenu()).slots.get(i);
            if (!(slot instanceof GhostSlot)) continue;
            final GhostSlot ghostSlot = (GhostSlot)slot;
            final int finalI = i;
            targets.add(new IGhostIngredientHandler.Target<I>(this){

                public Rect2i getArea() {
                    return new Rect2i(screen.getGuiLeft() + slot.x, screen.getGuiTop() + slot.y, 16, 16);
                }

                public void accept(I ingredientObj) {
                    ItemStack stack;
                    if (ingredientObj instanceof ItemStack) {
                        stack = (ItemStack)ingredientObj;
                        PacketDistributor.sendToServer((CustomPacketPayload)new JEISyncToMenu(finalI, stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        ghostSlot.set(stack.copyWithCount(1));
                    }
                    if (ingredientObj instanceof FluidStack) {
                        stack = (FluidStack)ingredientObj;
                        PacketDistributor.sendToServer((CustomPacketPayload)new JEISyncToMenuFluid(finalI, (FluidStack)stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        ghostSlot.setFluid((FluidStack)stack);
                    }
                    if (ModList.get().isLoaded("mekanism") && ingredientObj instanceof ChemicalStack) {
                        stack = (ChemicalStack)ingredientObj;
                        PacketDistributor.sendToServer((CustomPacketPayload)new JEISyncToMenuChemical(finalI, (ChemicalStack)stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        ghostSlot.setChemical(stack);
                    }
                }
            });
        }
        return targets;
    }

    public void onComplete() {
    }
}

