/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.mixin.client;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.FileUtil;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.client.ClientHooks;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.lodestar.lodestone.LodestoneLib;
import team.lodestar.lodestone.systems.rendering.shader.IShaderInstance;
import team.lodestar.lodestone.systems.rendering.shader.LodestoneProgram;
import team.lodestar.lodestone.systems.rendering.shader.SamplerType;

@Mixin(value={ShaderInstance.class})
public class ShaderInstanceMixin
implements IShaderInstance {
    private LodestoneProgram geometryProgram;
    @Unique
    private Map<String, SamplerType> samplerTypeMap = Maps.newHashMap();

    @Redirect(method={"parseSamplerNode"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z"))
    private boolean samplerDimension(List<String> samplerNames, Object s, @Local JsonElement json) {
        String name = s.toString();
        if (json.getAsJsonObject().has("type")) {
            String type1 = json.getAsJsonObject().get("type").getAsString();
            SamplerType type = SamplerType.fromString(type1);
            if (type == null) {
                LodestoneLib.LOGGER.warn("Unknown sampler type: " + type1);
            } else {
                this.samplerTypeMap.put(name, type);
            }
        }
        return samplerNames.add(name);
    }

    @Redirect(method={"apply"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;bindTexture(I)V"))
    private void bindTex(int textureBinding, @Local String s) {
        if (this.samplerTypeMap.containsKey(s)) {
            SamplerType type = this.samplerTypeMap.get(s);
            this.bindTexture(type.getGlType(), textureBinding);
        } else {
            RenderSystem.bindTexture((int)textureBinding);
        }
    }

    private void bindTexture(int samplerType, int texture) {
        GlStateManager.TextureState activeTexture = GlStateManager.TEXTURES[GlStateManager.activeTexture];
        if (texture != activeTexture.binding) {
            activeTexture.binding = texture;
            GL11.glBindTexture((int)samplerType, (int)texture);
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/server/packs/resources/ResourceProvider;Lnet/minecraft/resources/ResourceLocation;Lcom/mojang/blaze3d/vertex/VertexFormat;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/GsonHelper;getAsString(Lcom/google/gson/JsonObject;Ljava/lang/String;)Ljava/lang/String;", ordinal=1)})
    private void lodestone$setGeometryProgram(ResourceProvider resourceProvider, ResourceLocation shaderLocation, VertexFormat vertexFormat, CallbackInfo ci, @Local(ordinal=0) JsonObject json) throws IOException {
        if (json.has("geometry")) {
            String geometry = GsonHelper.getAsString((JsonObject)json, (String)"geometry");
            this.geometryProgram = ShaderInstanceMixin.lodestone$getOrCreate(resourceProvider, LodestoneProgram.Type.GEOMETRY, geometry);
            LodestoneLib.LOGGER.info("Loaded geometry program: " + geometry);
        }
    }

    @Inject(method={"attachToProgram"}, at={@At(value="TAIL")})
    private void attachToProgram(CallbackInfo ci) {
        if (this.geometryProgram != null) {
            this.geometryProgram.attachToShader((Shader)((ShaderInstance)this));
        }
    }

    @Inject(method={"close"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/shaders/ProgramManager;releaseProgram(Lcom/mojang/blaze3d/shaders/Shader;)V", shift=At.Shift.BEFORE)})
    public void close(CallbackInfo ci) {
        if (this.geometryProgram != null) {
            this.geometryProgram.close();
            LodestoneLib.LOGGER.info("Closed geometry program: " + this.geometryProgram.getName());
            this.geometryProgram = null;
        }
    }

    @Unique
    private static LodestoneProgram lodestone$getOrCreate(final ResourceProvider resourceProvider, LodestoneProgram.Type programType, String name) throws IOException {
        LodestoneProgram program;
        LodestoneProgram program1 = programType.getPrograms().get(name);
        if (program1 == null) {
            ResourceLocation loc = ResourceLocation.parse((String)name);
            String var10000 = loc.getPath();
            String s = "shaders/core/" + var10000 + programType.getExtension();
            ResourceLocation resourcelocation = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)s);
            Resource resource = resourceProvider.getResourceOrThrow(resourcelocation);
            try (InputStream inputstream = resource.open();){
                final String s1 = FileUtil.getFullResourcePath((String)s);
                program = LodestoneProgram.compileShader(programType, name, inputstream, resource.sourcePackId(), new GlslPreprocessor(){
                    private final Set<String> importedPaths = Sets.newHashSet();

                    public String applyImport(boolean p_173374_, String p_173375_) {
                        String string;
                        block9: {
                            ResourceLocation resourcelocation = ClientHooks.getShaderImportLocation((String)s1, (boolean)p_173374_, (String)p_173375_);
                            if (!this.importedPaths.add(resourcelocation.toString())) {
                                return null;
                            }
                            BufferedReader reader = resourceProvider.openAsReader(resourcelocation);
                            try {
                                string = IOUtils.toString((Reader)reader);
                                if (reader == null) break block9;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (reader != null) {
                                        try {
                                            ((Reader)reader).close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (IOException ioexception) {
                                    LodestoneLib.LOGGER.error("Could not open GLSL import {}: {}", (Object)resourcelocation, (Object)ioexception.getMessage());
                                    return "#error " + ioexception.getMessage();
                                }
                            }
                            ((Reader)reader).close();
                        }
                        return string;
                    }
                });
            }
        } else {
            program = program1;
        }
        return program;
    }

    @Override
    @Nullable
    public LodestoneProgram getGeometryProgram() {
        return this.geometryProgram;
    }
}

