/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.enchanting;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import team.lodestar.lodestone.LodestoneLib;
import team.lodestar.lodestone.systems.enchanting.LocatedEnchantmentEffect;
import team.lodestar.lodestone.systems.enchanting.LodestoneEnchantmentDataHelper;
import team.lodestar.lodestone.systems.enchanting.LodestoneEntityEnchantmentEffectFilter;

public class LodestoneEnchantmentEntityEffectHelper {
    public static <T extends EnchantmentEntityEffect> boolean hasEnchantmentEffect(ItemStack item, LodestoneEntityEnchantmentEffectFilter<T> filter) {
        return LodestoneEnchantmentEntityEffectHelper.findEnchantmentEffect(item, filter).isPresent();
    }

    public static <T extends EnchantmentEntityEffect> LocatedEnchantmentEffect<T> findEnchantmentEffect(ItemStack item, LodestoneEntityEnchantmentEffectFilter<T> filter) {
        AtomicReference result = new AtomicReference(new LocatedEnchantmentEffect.EmptyEnchantmentEffect());
        try {
            LodestoneEnchantmentDataHelper.runIterationOnItem(item, filter.getEnchantmentFilter(), (enchantment, enchantmentLevel) -> {
                DataComponentMap componentMap = ((Enchantment)enchantment.value()).effects();
                Optional<EnchantmentEntityEffect> matchingEffect = LodestoneEnchantmentEntityEffectHelper.findEnchantmentEffect(item, componentMap, filter);
                matchingEffect.ifPresent(t -> result.set(new LocatedEnchantmentEffect<EnchantmentEntityEffect>((EnchantmentEntityEffect)t, (Holder<Enchantment>)enchantment, enchantmentLevel)));
            }, () -> result.get() != null);
        }
        catch (Exception ignored) {
            return result.get();
        }
        return result.get();
    }

    public static <T extends EnchantmentEntityEffect> Optional<T> findEnchantmentEffect(ItemStack item, DataComponentMap map, LodestoneEntityEnchantmentEffectFilter<T> filter) {
        List<T> effects = LodestoneEnchantmentEntityEffectHelper.getEntityEffects(item, map, filter);
        if (effects.isEmpty()) {
            return Optional.empty();
        }
        if (effects.size() > 1) {
            LodestoneLib.LOGGER.warn("Cannot isolate an enchantment effect instance.");
            return Optional.empty();
        }
        return Optional.of((EnchantmentEntityEffect)effects.getFirst());
    }

    public static <T extends EnchantmentEntityEffect> List<T> getEntityEffects(ItemStack item, DataComponentMap map, LodestoneEntityEnchantmentEffectFilter<T> filter) {
        return LodestoneEnchantmentDataHelper.getMatchingEffects(item, map, filter.getClassFilter(), filter.asCondition());
    }

    public static List<LevelBasedValue> findEntityEffectValues(EnchantmentEntityEffect effect) {
        ArrayList<LevelBasedValue> values = new ArrayList<LevelBasedValue>();
        Class clazz = effect.getClass();
        record Accessor(Class<?> type, Supplier<Object> getter) {
        }
        ArrayList<Accessor> accessors = new ArrayList<Accessor>();
        if (clazz.isRecord()) {
            for (AnnotatedElement annotatedElement : clazz.getRecordComponents()) {
                Method accessor = ((RecordComponent)annotatedElement).getAccessor();
                accessors.add(new Accessor(((RecordComponent)annotatedElement).getType(), () -> LodestoneEnchantmentEntityEffectHelper.lambda$findEntityEffectValues$3(accessor, effect, (RecordComponent)annotatedElement)));
            }
        } else {
            for (AnnotatedElement annotatedElement : clazz.getDeclaredFields()) {
                ((Field)annotatedElement).setAccessible(true);
                accessors.add(new Accessor(((Field)annotatedElement).getType(), () -> LodestoneEnchantmentEntityEffectHelper.lambda$findEntityEffectValues$4((Field)annotatedElement, effect)));
            }
        }
        for (Accessor accessor : accessors) {
            Object t;
            Optional optional;
            Object object = accessor.getter.get();
            if (object instanceof LevelBasedValue) {
                LevelBasedValue levelBasedValue = (LevelBasedValue)object;
                values.add(levelBasedValue);
                continue;
            }
            if (!(object instanceof Optional) || !(optional = (Optional)object).isPresent() || !((t = optional.get()) instanceof LevelBasedValue)) continue;
            LevelBasedValue value = (LevelBasedValue)t;
            values.add(value);
        }
        return values;
    }

    private static /* synthetic */ Object lambda$findEntityEffectValues$4(Field field, EnchantmentEntityEffect effect) {
        try {
            return field.get(effect);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to access field: " + field.getName(), e);
        }
    }

    private static /* synthetic */ Object lambda$findEntityEffectValues$3(Method accessor, EnchantmentEntityEffect effect, RecordComponent component) {
        try {
            return accessor.invoke((Object)effect, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to access record: " + component.getName(), e);
        }
    }
}

