/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.StateShards;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;

public class LodestoneRenderType
extends RenderType {
    public final HashMap<Object, LodestoneRenderType> copies = new HashMap();
    public final RenderType.CompositeState state;
    private final RenderType outline;
    private final boolean isOutline;
    private final boolean isAdditive;
    private final ShaderUniformHandler uniformHandler;

    public LodestoneRenderType(String pName, VertexFormat pFormat, VertexFormat.Mode pMode, int pBufferSize, boolean pAffectsCrumbling, boolean pSortOnUpload, RenderType.CompositeState pState, @Nullable ShaderUniformHandler uniformHandler) {
        super(pName, pFormat, pMode, pBufferSize, pAffectsCrumbling, pSortOnUpload, () -> pState.states.forEach(RenderStateShard::setupRenderState), () -> pState.states.forEach(RenderStateShard::clearRenderState));
        this.state = pState;
        this.outline = pState.outlineProperty == RenderType.OutlineProperty.AFFECTS_OUTLINE ? (RenderType)pState.textureState.cutoutTexture().map(p_173270_ -> (RenderType)RenderType.CompositeRenderType.OUTLINE.apply(p_173270_, pState.cullState)).orElse(null) : null;
        this.isOutline = pState.outlineProperty == RenderType.OutlineProperty.IS_OUTLINE;
        this.isAdditive = LodestoneRenderType.isAdditive(this);
        this.uniformHandler = uniformHandler;
    }

    protected LodestoneRenderType(String name, LodestoneRenderType original) {
        this(name, original.format, original.mode, original.bufferSize, original.affectsCrumbling, original.sortOnUpload, original.state, original.uniformHandler);
    }

    protected LodestoneRenderType(String name, LodestoneRenderType original, ShaderUniformHandler uniformHandler) {
        this(name, original.format, original.mode, original.bufferSize, original.affectsCrumbling, original.sortOnUpload, original.state, uniformHandler);
    }

    protected LodestoneRenderType(String name, LodestoneRenderType original, Consumer<ShaderUniformHandler> uniformHandler) {
        this(name, original.format, original.mode, original.bufferSize, original.affectsCrumbling, original.sortOnUpload, original.state, new ShaderUniformHandler(original.uniformHandler).accept(uniformHandler));
    }

    protected LodestoneRenderType(String name, LodestoneRenderType original, ShaderUniformHandler uniformHandler, Consumer<LodestoneRenderTypes.LodestoneCompositeStateBuilder> modifier) {
        this(name, original.format, original.mode, original.bufferSize, original.affectsCrumbling, original.sortOnUpload, LodestoneRenderTypes.builder(original.state).accepts(modifier).createCompositeState(), uniformHandler);
    }

    protected LodestoneRenderType(String name, LodestoneRenderType original, Consumer<ShaderUniformHandler> uniformHandler, Consumer<LodestoneRenderTypes.LodestoneCompositeStateBuilder> modifier) {
        this(name, original.format, original.mode, original.bufferSize, original.affectsCrumbling, original.sortOnUpload, LodestoneRenderTypes.builder(original.state).accepts(modifier).createCompositeState(), new ShaderUniformHandler(original.uniformHandler).accept(uniformHandler));
    }

    public LodestoneRenderType copy(Object key) {
        if (!this.copies.containsKey(key)) {
            this.copies.put(key, new LodestoneRenderType(this.name, this));
        }
        return this.copies.get(key);
    }

    public LodestoneRenderType copy(Object key, ShaderUniformHandler uniformHandler) {
        if (!this.copies.containsKey(key)) {
            this.copies.put(key, new LodestoneRenderType(this.name, this, uniformHandler));
        }
        return this.copies.get(key);
    }

    public LodestoneRenderType copy(Object key, Consumer<ShaderUniformHandler> uniformHandler) {
        if (!this.copies.containsKey(key)) {
            this.copies.put(key, new LodestoneRenderType(this.name, this, uniformHandler));
        }
        return this.copies.get(key);
    }

    public LodestoneRenderType copy(Object key, ShaderUniformHandler uniformHandler, Consumer<LodestoneRenderTypes.LodestoneCompositeStateBuilder> modifier) {
        if (!this.copies.containsKey(key)) {
            this.copies.put(key, new LodestoneRenderType(this.name, this, uniformHandler, modifier));
        }
        return this.copies.get(key);
    }

    public LodestoneRenderType copy(Object key, Consumer<ShaderUniformHandler> uniformHandler, Consumer<LodestoneRenderTypes.LodestoneCompositeStateBuilder> modifier) {
        if (!this.copies.containsKey(key)) {
            this.copies.put(key, new LodestoneRenderType(this.name, this, uniformHandler, modifier));
        }
        return this.copies.get(key);
    }

    public static boolean isAdditive(LodestoneRenderType renderType) {
        return renderType.state.transparencyState.equals(StateShards.ADDITIVE_TRANSPARENCY) || renderType.state.transparencyState.equals(ADDITIVE_TRANSPARENCY);
    }

    @Nullable
    public ShaderUniformHandler getUniformHandler() {
        return this.uniformHandler;
    }

    public Optional<RenderType> outline() {
        return Optional.ofNullable(this.outline);
    }

    public boolean isOutline() {
        return this.isOutline;
    }

    public String toString() {
        return "RenderType[" + this.name + ":" + String.valueOf(this.state) + "]";
    }

    public void draw(MeshData meshData) {
        RenderSystem.depthMask((boolean)this.state.writeMaskState.writeDepth);
        this.setupRenderState();
        BufferUploader.drawWithShader((MeshData)meshData);
        this.clearRenderState();
    }

    public boolean isAdditive() {
        return this.isAdditive;
    }
}

