/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.rendeertype;

import java.util.Objects;
import java.util.function.Consumer;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeProvider;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;

public class LodestoneRenderTypeBuilder {
    private final RenderTypeProvider provider;
    private RenderTypeToken token;

    public LodestoneRenderTypeBuilder(RenderTypeProvider provider, RenderTypeToken token) {
        this.provider = provider;
        this.token = token;
    }

    public LodestoneRenderTypeBuilder withUniformHandler(ShaderUniformHandler uniformHandler) {
        this.token = this.token.addUniformHandler(uniformHandler);
        return this;
    }

    public LodestoneRenderTypeBuilder withUniformHandler(Consumer<ShaderUniformHandler> modifier) {
        this.token = this.token.addUniformHandler(modifier);
        return this;
    }

    public LodestoneRenderTypeBuilder withModifier(Consumer<LodestoneRenderTypes.LodestoneCompositeStateBuilder> modifier) {
        this.token = this.token.addModifier(modifier);
        return this;
    }

    public LodestoneRenderType getRenderType() {
        return this.provider.createRenderType(this.token);
    }

    public RenderTypeProvider getProvider() {
        return this.provider;
    }

    public RenderTypeToken getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LodestoneRenderTypeBuilder that = (LodestoneRenderTypeBuilder)o;
        return Objects.equals(this.token, that.token);
    }

    public int hashCode() {
        return Objects.hash(this.token);
    }
}

