/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Optional;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL30;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;

public class CubeMapTexture
extends AbstractTexture {
    protected final ResourceLocation location;
    protected final boolean alpha;
    private int width;
    private int height;
    private static final String[] CUBE_MAP_SIDES = new String[]{"right", "left", "top", "bottom", "front", "back"};

    public CubeMapTexture(ResourceLocation location, boolean hasAlphaChannel) {
        this.location = location;
        this.alpha = hasAlphaChannel;
    }

    public void load(@NotNull ResourceManager resourceManager) {
        this.id = GL30.glGenTextures();
        GL30.glBindTexture((int)34067, (int)this.id);
        for (int i = 0; i < CUBE_MAP_SIDES.length; ++i) {
            ResourceLocation sideLocation = ResourceLocation.fromNamespaceAndPath((String)this.location.getNamespace(), (String)(this.location.getPath() + "_" + CUBE_MAP_SIDES[i] + (this.alpha ? ".png" : ".jpg")));
            Optional resource = resourceManager.getResource(sideLocation);
            if (!resource.isPresent()) continue;
            try {
                ByteBuffer textureData = TextureUtil.readResource((InputStream)((Resource)resource.get()).open());
                textureData.rewind();
                try (MemoryStack stack = MemoryStack.stackPush();){
                    IntBuffer width = stack.mallocInt(1);
                    IntBuffer height = stack.mallocInt(1);
                    IntBuffer channels = stack.mallocInt(1);
                    ByteBuffer image = STBImage.stbi_load_from_memory((ByteBuffer)textureData, (IntBuffer)width, (IntBuffer)height, (IntBuffer)channels, (int)(this.alpha ? 4 : 3));
                    if (image == null) {
                        throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
                    }
                    int texFormat = this.alpha ? 6408 : 6407;
                    GL30.glTexImage2D((int)(34069 + i), (int)0, (int)texFormat, (int)width.get(), (int)height.get(), (int)0, (int)texFormat, (int)5121, (ByteBuffer)image);
                    this.width = width.get(0);
                    this.height = height.get(0);
                    STBImage.stbi_image_free((ByteBuffer)image);
                    continue;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load cubemap side: " + String.valueOf(sideLocation), e);
            }
        }
        GL30.glTexParameteri((int)34067, (int)10241, (int)9729);
        GL30.glTexParameteri((int)34067, (int)10240, (int)9729);
        GL30.glTexParameteri((int)34067, (int)10242, (int)33071);
        GL30.glTexParameteri((int)34067, (int)10243, (int)33071);
        GL30.glTexParameteri((int)34067, (int)32882, (int)33071);
    }

    public void bind() {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glBindTexture((int)34067, (int)this.id);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

