/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.impact;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.config.DatabankClientConfig;
import com.cmdpro.databank.impact.ImpactFrameHandler;
import com.cmdpro.databank.shaders.PostShaderInstance;
import com.mojang.blaze3d.pipeline.RenderTarget;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;

public class ImpactShader
extends PostShaderInstance {
    @Override
    public ResourceLocation getShaderLocation() {
        return Databank.locate("shaders/post/impact.json");
    }

    @Override
    public void setUniforms(PostPass instance) {
        super.setUniforms(instance);
        instance.getEffect().setSampler("ImpactSampler", () -> ((RenderTarget)ImpactFrameHandler.getImpactTarget()).getColorTextureId());
        instance.getEffect().setSampler("FrozenImpactSampler", () -> ((RenderTarget)ImpactFrameHandler.getFrozenImpactTarget()).getColorTextureId());
        float progress = 0.0f;
        if (ImpactFrameHandler.impactFrame != null) {
            float maxProgress = (float)ImpactFrameHandler.impactFrame.startTicks / 20.0f;
            progress = this.getTime() / maxProgress;
        }
        instance.getEffect().safeGetUniform("alpha").set(ImpactFrameHandler.impactFrame != null ? ((Float)ImpactFrameHandler.impactFrame.alpha.getValue(progress)).floatValue() : 0.0f);
    }

    @Override
    public void beforeProcess() {
        super.beforeProcess();
        if (ImpactFrameHandler.impactFrame == null) {
            this.setActive(false);
        }
        if (!DatabankClientConfig.allowImpactVisuals) {
            this.setActive(false);
        }
    }
}

