/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.instanceddimension;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.instanceddimension.InstancedDimensionManager;
import com.cmdpro.databank.instanceddimension.LevelLinkedDelegateBorderChangeListener;
import com.cmdpro.databank.misc.PlayerDataUtil;
import com.cmdpro.databank.mixin.ChunkMapAccessor;
import com.cmdpro.databank.mixin.MinecraftServerAccessor;
import com.cmdpro.databank.mixin.WorldBorderAccessor;
import com.cmdpro.databank.networking.ModMessages;
import com.cmdpro.databank.networking.packet.AddDimensionS2CPacket;
import com.cmdpro.databank.networking.packet.RemoveDimensionS2CPacket;
import com.cmdpro.databank.registry.AttachmentTypeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.apache.commons.io.FileUtils;
import org.spongepowered.include.com.google.common.collect.ImmutableList;

public class InstancedDimension {
    public static final Codec<InstancedDimension> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LevelStem.CODEC.fieldOf("stem").forGetter(obj -> obj.stem), (App)Codec.BOOL.fieldOf("saves").forGetter(obj -> obj.saves), (App)Codec.BOOL.optionalFieldOf("deletesWhenNoPlayers", (Object)false).forGetter(obj -> obj.deletesWhenNoPlayers)).apply((Applicative)instance, InstancedDimension::new));
    public ResourceLocation id;
    public LevelStem stem;
    public boolean saves;
    public boolean deletesWhenNoPlayers;

    public InstancedDimension(LevelStem stem, boolean saves, boolean deletesWhenNoPlayers) {
        this.stem = stem;
        this.saves = saves;
        this.deletesWhenNoPlayers = deletesWhenNoPlayers;
    }

    public Instance create(String identifier) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)Databank.locate(this.id.getNamespace() + "-" + this.id.getPath() + "-" + identifier));
        return new Instance(this.id, (ResourceKey<Level>)key);
    }

    public Instance create() {
        return this.create(UUID.randomUUID().toString());
    }

    protected Supplier<AttachmentType<ArrayList<Instance>>> getAttachmentType() {
        return this.saves ? AttachmentTypeRegistry.INSTANCED_DIMENSIONS : AttachmentTypeRegistry.TEMP_INSTANCED_DIMENSIONS;
    }

    public static class Instance {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("dimension").forGetter(obj -> obj.dimension), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("key").forGetter(obj -> obj.key)).apply((Applicative)instance, Instance::new));
        public ResourceLocation dimension;
        public ResourceKey<Level> key;
        public ServerLevel level;

        public Instance(ResourceLocation dimension, ResourceKey<Level> key) {
            this.dimension = dimension;
            this.key = key;
        }

        public InstancedDimension getInstancedDimension() {
            return InstancedDimensionManager.instanceddimensions.get(this.dimension);
        }

        public ServerLevel getOrCreateDimension(MinecraftServer server) {
            if (this.level == null) {
                this.level = this.createDimension(server);
            }
            return this.level;
        }

        protected ServerLevel createDimension(MinecraftServer server) {
            LevelStem stem = this.getInstancedDimension().stem;
            MinecraftServerAccessor accessor = (MinecraftServerAccessor)server;
            ServerLevel overworld = server.getLevel(Level.OVERWORLD);
            WorldBorder worldborder = overworld.getWorldBorder();
            WorldOptions worldoptions = server.getWorldData().worldGenOptions();
            long i = worldoptions.seed();
            long j = BiomeManager.obfuscateSeed((long)i);
            RandomSequences randomsequences = overworld.getRandomSequences();
            ResourceKey resourcekey1 = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)this.key.location());
            DerivedLevelData derivedleveldata = new DerivedLevelData(server.getWorldData(), server.getWorldData().overworldData());
            ServerLevel serverlevel1 = new ServerLevel(server, accessor.getExecutor(), accessor.getStorageSource(), (ServerLevelData)derivedleveldata, resourcekey1, stem, ((ChunkMapAccessor)overworld.getChunkSource().chunkMap).getProgressListener(), server.getWorldData().isDebugWorld(), j, (List)ImmutableList.of(), false, randomsequences);
            LevelLinkedDelegateBorderChangeListener listener = new LevelLinkedDelegateBorderChangeListener(serverlevel1);
            worldborder.addListener((BorderChangeListener)listener);
            accessor.getLevels().put((ResourceKey<Level>)resourcekey1, serverlevel1);
            NeoForge.EVENT_BUS.post((Event)new LevelEvent.Load((LevelAccessor)accessor.getLevels().get(this.key)));
            server.markWorldsDirty();
            ModMessages.sendToAllPlayers(new AddDimensionS2CPacket(this.key));
            ArrayList list = (ArrayList)server.overworld().getData(this.getInstancedDimension().getAttachmentType());
            if (list.stream().noneMatch(k -> k.key.equals(this.key))) {
                list.add(this);
            }
            server.overworld().setData(this.getInstancedDimension().getAttachmentType(), (Object)list);
            return serverlevel1;
        }

        public void removeDimension(MinecraftServer server) {
            MinecraftServerAccessor accessor = (MinecraftServerAccessor)server;
            for (Player player : this.level.players()) {
                InstancedDimensionManager.teleportPlayerOut(server, player);
            }
            for (String string : PlayerDataUtil.getAllOfflineUUIDS(server)) {
                PlayerDataUtil.modifyOfflinePlayerData(server, string, data -> {
                    ResourceLocation lastLocationDataKey;
                    CompoundTag attachments;
                    String attachmentsKey;
                    ResourceKey resourcekey;
                    if (data.contains("Dimension") && (resourcekey = (ResourceKey)DimensionType.parseLegacy((Dynamic)new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)data.get("Dimension"))).getOrThrow()).equals(this.key) && data.contains(attachmentsKey = ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"attachments").toString()) && (attachments = data.getCompound(attachmentsKey)).contains((lastLocationDataKey = ResourceLocation.fromNamespaceAndPath((String)"databank", (String)"last_location_data")).toString())) {
                        CompoundTag lastLocationData = attachments.getCompound(lastLocationDataKey.toString());
                        String level = lastLocationData.getString("level");
                        ListTag pos = lastLocationData.getList("pos", 6);
                        data.putString("Dimension", level);
                        data.put("Pos", (Tag)pos);
                        return Optional.of(data);
                    }
                    return Optional.empty();
                });
            }
            if (accessor.getLevels().containsKey(this.key)) {
                try {
                    ServerLevel overworld = server.getLevel(Level.OVERWORLD);
                    ServerLevel serverLevel = accessor.getLevels().get(this.key);
                    NeoForge.EVENT_BUS.post((Event)new LevelEvent.Unload((LevelAccessor)serverLevel));
                    accessor.getLevels().remove(this.key);
                    List<BorderChangeListener> listeners = ((WorldBorderAccessor)overworld.getWorldBorder()).getListeners();
                    BorderChangeListener toRemove = null;
                    for (BorderChangeListener i2 : listeners) {
                        if (!(i2 instanceof LevelLinkedDelegateBorderChangeListener)) continue;
                        LevelLinkedDelegateBorderChangeListener listener = (LevelLinkedDelegateBorderChangeListener)i2;
                        if (listener.level != serverLevel) continue;
                        toRemove = i2;
                    }
                    listeners.remove(toRemove);
                    serverLevel.close();
                    server.markWorldsDirty();
                    Path path = ((MinecraftServerAccessor)server).getStorageSource().getDimensionPath(this.key).toRealPath(new LinkOption[0]);
                    FileUtils.deleteDirectory((File)new File(path.toString()));
                    ModMessages.sendToAllPlayers(new RemoveDimensionS2CPacket(this.key));
                    ArrayList list = (ArrayList)server.overworld().getData(this.getInstancedDimension().getAttachmentType());
                    list.removeIf(i -> i.key.equals(this.key));
                    server.overworld().setData(this.getInstancedDimension().getAttachmentType(), (Object)list);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

