/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.instanceddimension;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.instanceddimension.InstancedDimension;
import com.cmdpro.databank.instanceddimension.PlayerLastLocationData;
import com.cmdpro.databank.registry.AttachmentTypeRegistry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="databank")
public class InstancedDimensionManager
extends SimpleJsonResourceReloadListener {
    public static HashMap<ResourceLocation, InstancedDimension> instanceddimensions = new HashMap();
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static InstancedDimensionManager instance;

    protected InstancedDimensionManager() {
        super(GSON, "databank/instanced_dimensions");
    }

    public static InstancedDimensionManager getOrCreateInstance() {
        if (instance == null) {
            instance = new InstancedDimensionManager();
        }
        return instance;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        instanceddimensions = new HashMap();
        Databank.LOGGER.info("[DATABANK] Adding Databank Instanced Dimensions");
        for (Map.Entry<ResourceLocation, JsonElement> i : pObject.entrySet()) {
            ResourceLocation location = i.getKey();
            if (location.getPath().startsWith("_")) continue;
            try {
                JsonObject obj = i.getValue().getAsJsonObject();
                InstancedDimension dimension = (InstancedDimension)InstancedDimension.CODEC.parse((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.getRegistryLookup()), (Object)obj).getOrThrow();
                dimension.id = i.getKey();
                instanceddimensions.put(i.getKey(), dimension);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                Databank.LOGGER.error("[DATABANK ERROR] Parsing error loading instanced dimension type {}", (Object)location, (Object)e);
            }
        }
        Databank.LOGGER.info("[DATABANK] Loaded {} Instanced Dimensions", (Object)instanceddimensions.size());
    }

    @SubscribeEvent
    public static void onTick(ServerTickEvent.Post event) {
        ServerLevel overworld = event.getServer().overworld();
        List<InstancedDimension.Instance> instances = InstancedDimensionManager.getInstances((Level)overworld);
        ArrayList<InstancedDimension.Instance> toRemove = new ArrayList<InstancedDimension.Instance>();
        for (InstancedDimension.Instance i : instances) {
            if (i.level == null || !i.getInstancedDimension().deletesWhenNoPlayers || !i.level.players().isEmpty()) continue;
            toRemove.add(i);
        }
        for (InstancedDimension.Instance i : toRemove) {
            i.removeDimension(event.getServer());
        }
    }

    @SubscribeEvent
    public static void onPlayerTravel(EntityTravelToDimensionEvent event) {
        if (!(event.getEntity() instanceof Player) || event.getEntity().level().isClientSide) {
            return;
        }
        ResourceKey to = event.getDimension();
        ResourceKey from = event.getEntity().level().dimension();
        ServerLevel overworld = event.getEntity().getServer().overworld();
        List<InstancedDimension.Instance> instances = InstancedDimensionManager.getInstances((Level)overworld);
        boolean inDimension = false;
        boolean wasInDimension = false;
        for (InstancedDimension.Instance i : instances) {
            if (i.level != null && to.equals(i.key)) {
                inDimension = true;
            }
            if (i.level == null || !from.equals(i.key)) continue;
            wasInDimension = true;
        }
        if (inDimension && !wasInDimension) {
            event.getEntity().setData(AttachmentTypeRegistry.LAST_LOCATION_DATA, Optional.of(new PlayerLastLocationData((ResourceKey<Level>)from, event.getEntity().position())));
        }
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        ServerLevel overworld = event.getServer().overworld();
        List instances = (List)overworld.getData(AttachmentTypeRegistry.INSTANCED_DIMENSIONS);
        for (InstancedDimension.Instance i : instances.stream().toList()) {
            i.getOrCreateDimension(event.getServer());
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        ServerLevel overworld = event.getServer().overworld();
        List instances = (List)overworld.getData(AttachmentTypeRegistry.TEMP_INSTANCED_DIMENSIONS);
        for (InstancedDimension.Instance i : instances.stream().toList()) {
            i.removeDimension(event.getServer());
        }
    }

    @SubscribeEvent
    public static void playerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerLevel overworld;
        List instances;
        Player player = event.getEntity();
        MinecraftServer server = player.getServer();
        if (server == null) {
            return;
        }
        if (server.isSingleplayerOwner(player.getGameProfile()) && (instances = (List)(overworld = server.overworld()).getData(AttachmentTypeRegistry.TEMP_INSTANCED_DIMENSIONS)).stream().anyMatch(i -> i.key.equals((Object)player.level().dimension()))) {
            InstancedDimensionManager.teleportPlayerOut(server, player);
        }
    }

    public static void teleportPlayerOut(MinecraftServer server, Player player) {
        Optional data = (Optional)player.getData(AttachmentTypeRegistry.LAST_LOCATION_DATA);
        ResourceKey<Level> outside = Level.OVERWORLD;
        Vec3 pos = Vec3.ZERO;
        if (data.isPresent()) {
            outside = ((PlayerLastLocationData)data.get()).level;
            pos = ((PlayerLastLocationData)data.get()).pos;
        }
        player.teleportTo(server.getLevel((ResourceKey)outside), pos.x, pos.y, pos.z, Set.of(), player.yRotO, player.xRotO);
    }

    public static List<InstancedDimension.Instance> getInstances(Level level) {
        ArrayList<InstancedDimension.Instance> instances = new ArrayList<InstancedDimension.Instance>((Collection)level.getData(AttachmentTypeRegistry.TEMP_INSTANCED_DIMENSIONS));
        instances.addAll((Collection)level.getData(AttachmentTypeRegistry.INSTANCED_DIMENSIONS));
        return instances;
    }
}

