/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.misc;

import com.cmdpro.databank.misc.ColorGradient;
import com.cmdpro.databank.misc.TrailRender;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="databank")
public class TrailLeftoverHandler {
    private static final HashMap<TrailRender, ExtraTrailData> trailLeftovers = new HashMap();

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            PoseStack poseStack = event.getPoseStack();
            poseStack.pushPose();
            poseStack.translate(-event.getCamera().getPosition().x, -event.getCamera().getPosition().y, -event.getCamera().getPosition().z);
            for (Map.Entry<TrailRender, ExtraTrailData> i : new HashMap<TrailRender, ExtraTrailData>(trailLeftovers).entrySet()) {
                TrailRender trail = i.getKey();
                ExtraTrailData data = i.getValue();
                if (trail.getPositionCount() <= 0) {
                    trailLeftovers.remove(trail);
                    trail.stopTicking();
                    continue;
                }
                trail.render(poseStack, data.bufferSource, data.packedLight, data.gradient);
            }
            poseStack.popPose();
        }
    }

    public static void addTrail(TrailRender trail, MultiBufferSource bufferSource, int packedLight, ColorGradient gradient) {
        if (!trailLeftovers.containsKey(trail)) {
            trailLeftovers.put(trail, new ExtraTrailData(bufferSource, packedLight, gradient));
            trail.startTicking();
        }
    }

    public static void addTrail(TrailRender trail, MultiBufferSource bufferSource, int packedLight, Color color) {
        TrailLeftoverHandler.addTrail(trail, bufferSource, packedLight, ColorGradient.singleColor(color));
    }

    public static void addTrail(TrailRender trail, MultiBufferSource bufferSource, int packedLight, int color) {
        TrailLeftoverHandler.addTrail(trail, bufferSource, packedLight, new Color(color));
    }

    private record ExtraTrailData(MultiBufferSource bufferSource, int packedLight, ColorGradient gradient) {
    }
}

