/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.misc;

import com.cmdpro.databank.registry.AttachmentTypeRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforgespi.language.IModFileInfo;

@EventBusSubscriber(modid="databank")
public class VersionChangeHelper {
    private static final HashMap<String, PlayerVersionChangeListener> playerListeners = new HashMap();
    private static final HashMap<String, LevelVersionChangeListener> levelListeners = new HashMap();

    public static void registerPlayerListener(String modId, PlayerVersionChangeListener listener) {
        playerListeners.put(modId, listener);
    }

    public static void registerLevelListener(String modId, LevelVersionChangeListener listener) {
        levelListeners.put(modId, listener);
    }

    @SubscribeEvent
    protected static void onJoinLevel(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            HashMap oldVersions = (HashMap)player.getData(AttachmentTypeRegistry.MOD_VERSIONS);
            HashMap<String, String> newMap = VersionChangeHelper.createVersionMap(playerListeners.keySet());
            HashMap<String, VersionChange> changes = VersionChangeHelper.getChanges(oldVersions, newMap);
            for (Map.Entry<String, VersionChange> i : changes.entrySet()) {
                playerListeners.get(i.getKey()).onChange(i.getKey(), i.getValue().from, i.getValue().to, player);
            }
            player.setData(AttachmentTypeRegistry.MOD_VERSIONS, newMap);
        }
    }

    @SubscribeEvent
    protected static void onLevelLoad(LevelEvent.Load event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            HashMap oldVersions = (HashMap)level.getData(AttachmentTypeRegistry.MOD_VERSIONS);
            HashMap<String, String> newMap = VersionChangeHelper.createVersionMap(levelListeners.keySet());
            HashMap<String, VersionChange> changes = VersionChangeHelper.getChanges(oldVersions, newMap);
            for (Map.Entry<String, VersionChange> i : changes.entrySet()) {
                levelListeners.get(i.getKey()).onChange(i.getKey(), i.getValue().from, i.getValue().to, level);
            }
            level.setData(AttachmentTypeRegistry.MOD_VERSIONS, newMap);
        }
    }

    private static HashMap<String, VersionChange> getChanges(HashMap<String, String> oldMap, HashMap<String, String> newMap) {
        HashMap<String, VersionChange> changes = new HashMap<String, VersionChange>();
        for (Map.Entry<String, String> i : newMap.entrySet()) {
            boolean different = false;
            String oldVer = null;
            if (oldMap.containsKey(i.getKey())) {
                oldVer = oldMap.get(i.getKey());
                if (!oldVer.equals(i.getValue())) {
                    different = true;
                }
            } else {
                different = true;
            }
            if (!different) continue;
            changes.put(i.getKey(), new VersionChange(oldVer, i.getValue()));
        }
        return changes;
    }

    protected static HashMap<String, String> createVersionMap(Set<String> modIds) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String i : modIds) {
            IModFileInfo file = ModList.get().getModFileById(i);
            if (file == null) continue;
            map.put(i, file.versionString());
        }
        return map;
    }

    public static interface PlayerVersionChangeListener {
        public void onChange(String var1, String var2, String var3, ServerPlayer var4);
    }

    private record VersionChange(String from, String to) {
    }

    public static interface LevelVersionChangeListener {
        public void onChange(String var1, String var2, String var3, ServerLevel var4);
    }
}

