/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.networking.packet;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.dialogue.DialogueInstance;
import com.cmdpro.databank.dialogue.DialogueScreen;
import com.cmdpro.databank.dialogue.DialogueTree;
import com.cmdpro.databank.networking.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record DialogueOpenS2CPacket(DialogueTree tree, String entry) implements Message
{
    public static final CustomPacketPayload.Type<DialogueOpenS2CPacket> TYPE = new CustomPacketPayload.Type(Databank.locate("dialogue_open"));

    public static DialogueOpenS2CPacket read(FriendlyByteBuf buf) {
        DialogueTree tree = (DialogueTree)DialogueTree.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)buf));
        String entry = buf.readUtf();
        return new DialogueOpenS2CPacket(tree, entry);
    }

    public static void write(FriendlyByteBuf buf, DialogueOpenS2CPacket obj) {
        DialogueTree.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)buf), (Object)obj.tree);
        buf.writeUtf(obj.entry);
    }

    public CustomPacketPayload.Type<DialogueOpenS2CPacket> type() {
        return TYPE;
    }

    @Override
    public void handleClient(Minecraft minecraft, Player player, IPayloadContext context) {
        ClientHandler.openScreen(new DialogueInstance(this.tree, this.tree.entries.get(this.entry)));
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void openScreen(DialogueInstance instance) {
            Minecraft.getInstance().setScreen((Screen)new DialogueScreen(instance));
        }
    }
}

