/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.networking.packet;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.DatabankRegistries;
import com.cmdpro.databank.hidden.ClientHidden;
import com.cmdpro.databank.hidden.ClientHiddenListener;
import com.cmdpro.databank.hidden.Hidden;
import com.cmdpro.databank.hidden.HiddenManager;
import com.cmdpro.databank.hidden.HiddenTypeInstance;
import com.cmdpro.databank.networking.Message;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UnlockedHiddenSyncS2CPacket(List<ResourceLocation> hidden, boolean updateListeners) implements Message
{
    public static final CustomPacketPayload.Type<UnlockedHiddenSyncS2CPacket> TYPE = new CustomPacketPayload.Type(Databank.locate("unlocked_hidden_block_sync"));

    public static UnlockedHiddenSyncS2CPacket read(FriendlyByteBuf buf) {
        List blocks = buf.readList(FriendlyByteBuf::readResourceLocation);
        boolean updateListeners = buf.readBoolean();
        return new UnlockedHiddenSyncS2CPacket(blocks, updateListeners);
    }

    public static void write(FriendlyByteBuf buf, UnlockedHiddenSyncS2CPacket obj) {
        buf.writeCollection(obj.hidden, FriendlyByteBuf::writeResourceLocation);
        buf.writeBoolean(obj.updateListeners);
    }

    public CustomPacketPayload.Type<UnlockedHiddenSyncS2CPacket> type() {
        return TYPE;
    }

    @Override
    public void handleClient(Minecraft minecraft, Player player, IPayloadContext context) {
        if (this.updateListeners && !ClientHiddenListener.HIDDEN_LISTENERS.isEmpty()) {
            ArrayList<ResourceLocation> unlockedIds = new ArrayList<ResourceLocation>(this.hidden);
            ArrayList<ResourceLocation> lockedIds = new ArrayList<ResourceLocation>(ClientHidden.unlocked);
            unlockedIds.removeIf(lockedIds::remove);
            if (!lockedIds.isEmpty() || !unlockedIds.isEmpty()) {
                Hidden i;
                ArrayList<Hidden> unlockedList = new ArrayList<Hidden>(unlockedIds.size());
                ArrayList<Hidden> lockedList = new ArrayList<Hidden>(lockedIds.size());
                for (ResourceLocation id : lockedIds) {
                    i = HiddenManager.hidden.get(id);
                    if (i == null) continue;
                    lockedList.add(i);
                    ClientHiddenListener.HIDDEN_LISTENERS.forEach(listener -> listener.onHide(i));
                }
                ClientHiddenListener.HIDDEN_LISTENERS.forEach(listener -> listener.onHide(lockedList));
                for (ResourceLocation id : unlockedIds) {
                    i = HiddenManager.hidden.get(id);
                    if (i == null) continue;
                    unlockedList.add(i);
                    ClientHiddenListener.HIDDEN_LISTENERS.forEach(listener -> listener.onUnhide(i));
                }
                ClientHiddenListener.HIDDEN_LISTENERS.forEach(listener -> listener.onUnhide(unlockedList));
            }
        }
        ClientHidden.unlocked = this.hidden;
        for (HiddenTypeInstance.HiddenType i : DatabankRegistries.HIDDEN_TYPE_REGISTRY) {
            i.updateClient();
        }
    }
}

