/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.rendering;

import java.awt.Color;
import org.joml.Math;

public class ColorUtil {
    public static int RGBtoHex(int R, int G, int B, int A) {
        return B | G << 8 | R << 16 | A << 24;
    }

    public static int RGBtoHex(int R, int G, int B) {
        return ColorUtil.RGBtoHex(R, G, B, 255);
    }

    public static int RGBtoHex(Color color) {
        return ColorUtil.RGBtoHex(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static int[] hexToRGB(int hex) {
        int[] color = new int[]{hex >>> 16 & 0xFF, hex >>> 8 & 0xFF, hex & 0xFF, hex >>> 24 & 0xFF};
        return color;
    }

    public static Color hexToRGBColor(int hex) {
        int[] rgb = ColorUtil.hexToRGB(hex);
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public static Color blendColors(Color color1, Color color2, float blend) {
        return new Color(Math.lerp((float)((float)color1.getRed() / 255.0f), (float)((float)color2.getRed() / 255.0f), (float)blend), Math.lerp((float)((float)color1.getGreen() / 255.0f), (float)((float)color2.getGreen() / 255.0f), (float)blend), Math.lerp((float)((float)color1.getBlue() / 255.0f), (float)((float)color2.getBlue() / 255.0f), (float)blend), Math.lerp((float)((float)color1.getAlpha() / 255.0f), (float)((float)color2.getAlpha() / 255.0f), (float)blend));
    }

    public static Color mixColorsSubtractive(Color color1, Color color2) {
        return ColorUtil.mixColorsSubtractive(color1, color2, 1.0f);
    }

    public static Color mixColorsSubtractive(Color color1, Color color2, float alpha) {
        return ColorUtil.cmyToRgb(ColorUtil.blendCmy(ColorUtil.rgbToCmy(color1), ColorUtil.rgbToCmy(color2), alpha));
    }

    public static float[] rgbToCmy(Color color) {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float c = 1.0f - r;
        float m = 1.0f - g;
        float y = 1.0f - b;
        return new float[]{c, m, y};
    }

    public static float[] blendCmy(float[] cmy1, float[] cmy2, float intensity) {
        float c = cmy1[0] * (1.0f - intensity / 2.0f) + cmy2[0] * (intensity / 2.0f);
        float m = cmy1[1] * (1.0f - intensity / 2.0f) + cmy2[1] * (intensity / 2.0f);
        float y = cmy1[2] * (1.0f - intensity / 2.0f) + cmy2[2] * (intensity / 2.0f);
        return new float[]{c, m, y};
    }

    private static Color cmyToRgb(float[] cmy) {
        int r = (int)((1.0f - cmy[0]) * 255.0f);
        int g = (int)((1.0f - cmy[1]) * 255.0f);
        int b = (int)((1.0f - cmy[2]) * 255.0f);
        r = Math.min((int)255, (int)Math.max((int)0, (int)r));
        g = Math.min((int)255, (int)Math.max((int)0, (int)g));
        b = Math.min((int)255, (int)Math.max((int)0, (int)b));
        return new Color(r, g, b);
    }
}

