/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.worldgui;

import com.cmdpro.databank.networking.ModMessages;
import com.cmdpro.databank.networking.packet.WorldGuiInteractC2SPacket;
import com.cmdpro.databank.worldgui.WorldGuiEntity;
import com.cmdpro.databank.worldgui.WorldGuiHitResult;
import com.cmdpro.databank.worldgui.components.WorldGuiComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="databank")
public class WorldGuiClientEvents {
    @SubscribeEvent
    public static void interactionKeyMappingTriggeredEvent(InputEvent.InteractionKeyMappingTriggered event) {
        WorldGuiHitResult result;
        Entity entity;
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (hitResult instanceof WorldGuiHitResult && (entity = (result = (WorldGuiHitResult)hitResult).getEntity()) instanceof WorldGuiEntity) {
            WorldGuiEntity entity2 = (WorldGuiEntity)entity;
            if (entity2.gui != null && entity2.guiType != null) {
                Vec2 normal = result.result.normal;
                int x = (int)(normal.x * entity2.guiType.getRenderSize().x);
                int y = (int)(normal.y * entity2.guiType.getRenderSize().y);
                if (event.getKeyMapping().equals(Minecraft.getInstance().options.keyAttack)) {
                    entity2.gui.leftClick(true, (Player)Minecraft.getInstance().player, x, y);
                    for (WorldGuiComponent i : entity2.gui.components.stream().toList()) {
                        if (!entity2.gui.tryLeftClickComponent(true, (Player)Minecraft.getInstance().player, i, x, y)) continue;
                        i.leftClick(true, (Player)Minecraft.getInstance().player, x, y);
                    }
                    ModMessages.sendToServer(new WorldGuiInteractC2SPacket(entity2.getId(), 0, x, y));
                    event.setCanceled(true);
                } else if (event.getKeyMapping().equals(Minecraft.getInstance().options.keyUse)) {
                    entity2.gui.rightClick(true, (Player)Minecraft.getInstance().player, x, y);
                    for (WorldGuiComponent i : entity2.gui.components.stream().toList()) {
                        if (!entity2.gui.tryLeftClickComponent(true, (Player)Minecraft.getInstance().player, i, x, y)) continue;
                        i.rightClick(true, (Player)Minecraft.getInstance().player, x, y);
                    }
                    ModMessages.sendToServer(new WorldGuiInteractC2SPacket(entity2.getId(), 1, x, y));
                    event.setCanceled(true);
                }
            }
        }
    }
}

