/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.atlasapi.internal;

import io.redspace.atlasapi.AtlasApi;
import io.redspace.atlasapi.api.AssetHandler;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceList;
import net.minecraft.resources.ResourceLocation;

public class DynamicAtlas
extends TextureAtlas {
    public boolean hasBuilt = false;
    final AssetHandler handler;

    public void reset() {
        if (this.hasBuilt) {
            this.clearTextureData();
            this.hasBuilt = false;
        }
    }

    public DynamicAtlas(AssetHandler handler, TextureManager pTextureManager) {
        super(handler.getAtlasLocation());
        this.handler = handler;
        pTextureManager.register(this.location(), (AbstractTexture)this);
    }

    public void buildCustomContents() {
        AtlasApi.LOGGER.info("Atlas {}: Building custom contents start", (Object)this.location());
        long milis = System.currentTimeMillis();
        SpriteLoader loader = new SpriteLoader(this.location(), this.maxSupportedTextureSize(), 128, 128);
        SpriteResourceLoader spriteresourceloader = SpriteResourceLoader.create((Collection)SpriteLoader.DEFAULT_METADATA_SECTIONS);
        SpriteSourceList sources = new SpriteSourceList(this.handler.buildSpriteSources());
        List factories = sources.list(Minecraft.getInstance().getResourceManager());
        List<SpriteContents> contents = factories.stream().map(factory -> (SpriteContents)factory.apply(spriteresourceloader)).filter(Objects::nonNull).toList();
        SpriteLoader.Preparations preparations = loader.stitch(contents, 0, Runnable::run);
        this.upload(preparations);
        AtlasApi.LOGGER.info("Built Atlas: {} ({}x{}, {} sprites, {} ms)", new Object[]{this.location(), this.getWidth(), this.getHeight(), preparations.regions().size(), System.currentTimeMillis() - milis});
        this.hasBuilt = true;
    }

    public TextureAtlasSprite getSprite(ResourceLocation pLocation) {
        if (!this.hasBuilt) {
            this.buildCustomContents();
            this.hasBuilt = true;
        }
        return super.getSprite(pLocation);
    }
}

