/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.format.nbt;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SelfDescribedDeserializer;
import io.wispforest.endec.SelfDescribedSerializer;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.owo.serialization.format.nbt.NbtDeserializer;
import io.wispforest.owo.serialization.format.nbt.NbtSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;

public final class NbtEndec
implements Endec<Tag> {
    public static final Endec<Tag> ELEMENT = new NbtEndec();
    public static final Endec<CompoundTag> COMPOUND = new NbtEndec().xmap(CompoundTag.class::cast, compound -> compound);

    private NbtEndec() {
    }

    public void encode(SerializationContext ctx, Serializer<?> serializer, Tag value) {
        if (serializer instanceof SelfDescribedSerializer) {
            NbtDeserializer.of(value).readAny(ctx, serializer);
            return;
        }
        try {
            ByteArrayDataOutput output = ByteStreams.newDataOutput();
            NbtIo.writeAnyTag((Tag)value, (DataOutput)output);
            serializer.writeBytes(ctx, output.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to encode binary NBT in NbtEndec", e);
        }
    }

    public Tag decode(SerializationContext ctx, Deserializer<?> deserializer) {
        if (deserializer instanceof SelfDescribedDeserializer) {
            SelfDescribedDeserializer selfDescribedDeserializer = (SelfDescribedDeserializer)deserializer;
            NbtSerializer nbt = NbtSerializer.of();
            selfDescribedDeserializer.readAny(ctx, (Serializer)nbt);
            return (Tag)nbt.result();
        }
        try {
            return NbtIo.readAnyTag((DataInput)ByteStreams.newDataInput((byte[])deserializer.readBytes(ctx)), (NbtAccounter)NbtAccounter.unlimitedHeap());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse binary NBT in NbtEndec", e);
        }
    }
}

