/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.integration.waila;

import de.maxhenkel.pipez.blocks.PipeBlock;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class HUDHandlerPipes
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    static final HUDHandlerPipes INSTANCE = new HUDHandlerPipes();
    private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"pipez", (String)"pipe");

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        CompoundTag compound = blockAccessor.getServerData();
        if (compound.contains("Upgrade", 8)) {
            iTooltip.add((Component)Component.Serializer.fromJson((String)compound.getString("Upgrade"), (HolderLookup.Provider)blockAccessor.getLevel().registryAccess()));
        }
        iTooltip.addAll(this.getTooltips(blockAccessor, compound));
    }

    public void appendServerData(CompoundTag compound, BlockAccessor blockAccessor) {
        Block block = blockAccessor.getBlockState().getBlock();
        if (block instanceof PipeBlock) {
            PipeBlock pipe = (PipeBlock)block;
            BlockEntity te = blockAccessor.getBlockEntity();
            Direction selectedSide = pipe.getSelection(te.getBlockState(), (BlockGetter)blockAccessor.getLevel(), te.getBlockPos(), blockAccessor.getPlayer()).getKey();
            if (selectedSide == null) {
                return;
            }
            if (!(te instanceof UpgradeTileEntity)) {
                return;
            }
            PipeLogicTileEntity pipeTile = (PipeLogicTileEntity)te;
            if (!pipeTile.isExtracting(selectedSide)) {
                return;
            }
            ItemStack upgrade = pipeTile.getUpgradeItem(selectedSide);
            if (upgrade.isEmpty()) {
                compound.putString("Upgrade", Component.Serializer.toJson((Component)Component.translatable((String)"tooltip.pipez.no_upgrade"), (HolderLookup.Provider)blockAccessor.getLevel().registryAccess()));
            } else {
                compound.putString("Upgrade", Component.Serializer.toJson((Component)upgrade.getHoverName(), (HolderLookup.Provider)blockAccessor.getLevel().registryAccess()));
            }
            ArrayList<Component> tooltips = new ArrayList<Component>();
            for (PipeType<?, ?> pipeType : pipeTile.getPipeTypes()) {
                if (!pipeTile.isEnabled(selectedSide, pipeType)) continue;
                tooltips.add(pipeType.getTransferText(pipeTile.getUpgrade(selectedSide)));
            }
            this.putTooltips(blockAccessor, compound, tooltips);
        }
    }

    public void putTooltips(BlockAccessor blockAccessor, CompoundTag compound, List<Component> tooltips) {
        ListTag list = new ListTag();
        for (Component tooltip : tooltips) {
            list.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)tooltip, (HolderLookup.Provider)blockAccessor.getLevel().registryAccess())));
        }
        compound.put("Tooltips", (Tag)list);
    }

    public List<Component> getTooltips(BlockAccessor blockAccessor, CompoundTag compound) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        if (!compound.contains("Tooltips", 9)) {
            return tooltips;
        }
        ListTag list = compound.getList("Tooltips", 8);
        for (int i = 0; i < list.size(); ++i) {
            tooltips.add((Component)Component.Serializer.fromJson((String)list.getString(i), (HolderLookup.Provider)blockAccessor.getLevel().registryAccess()));
        }
        return tooltips;
    }

    public ResourceLocation getUid() {
        return UID;
    }
}

