/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting.cache;

import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.cache.IListRecipe;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;

@EventBusSubscriber(modid="immersiveengineering")
public class CachedRecipeList<R extends Recipe<?>> {
    public static final int INVALID_RELOAD_COUNT = -1;
    private static int reloadCount = 0;
    private final Supplier<RecipeType<R>> type;
    private Map<ResourceLocation, RecipeHolder<R>> recipes;
    private List<RecipeHolder<R>> recipeHolders;
    private boolean cachedDataIsClient;
    private int cachedAtReloadCount = -1;

    public CachedRecipeList(Supplier<RecipeType<R>> type) {
        this.type = type;
    }

    public CachedRecipeList(IERecipeTypes.TypeWithClass<R> type) {
        this((Supplier<RecipeType<R>>)type.type());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onTagsUpdated(TagsUpdatedEvent ev) {
        ++reloadCount;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRecipeUpdatedClient(RecipesUpdatedEvent ev) {
        ++reloadCount;
    }

    public static int getReloadCount() {
        return reloadCount;
    }

    public List<RecipeHolder<R>> getRecipes(@Nonnull Level level) {
        this.updateCache(level.getRecipeManager(), level.isClientSide());
        return Objects.requireNonNull(this.recipeHolders);
    }

    public Collection<ResourceLocation> getRecipeNames(@Nonnull Level level) {
        this.updateCache(level.getRecipeManager(), level.isClientSide());
        return Objects.requireNonNull(this.recipes).keySet();
    }

    public R getById(@Nonnull Level level, ResourceLocation name) {
        RecipeHolder<R> holder = this.holderById(level, name);
        return (R)(holder != null ? holder.value() : null);
    }

    public RecipeHolder<R> holderById(@Nonnull Level level, ResourceLocation name) {
        this.updateCache(level.getRecipeManager(), level.isClientSide());
        return this.recipes.get(name);
    }

    private void updateCache(RecipeManager manager, boolean isClient) {
        if (this.recipes != null && this.cachedAtReloadCount == reloadCount && (!this.cachedDataIsClient || isClient)) {
            return;
        }
        this.recipes = manager.getRecipes().stream().filter(iRecipe -> iRecipe.value().getType() == this.type.get()).flatMap(r -> {
            Recipe patt0$temp = r.value();
            if (patt0$temp instanceof IListRecipe) {
                IListRecipe listRecipe = (IListRecipe)patt0$temp;
                int total = listRecipe.getSubRecipes().size();
                String fmt = total >= 10000 ? "%05d" : (total >= 1000 ? "%04d" : (total >= 100 ? "%03d" : (total >= 10 ? "%02d" : "%01d")));
                return Streams.mapWithIndex(listRecipe.getSubRecipes().stream(), (subRecipe, i) -> new RecipeHolder(r.id().withSuffix(String.format(fmt, i)), subRecipe));
            }
            return Stream.of(r);
        }).collect(Collectors.toMap(RecipeHolder::id, rh -> rh));
        this.recipeHolders = List.copyOf(this.recipes.values());
        this.cachedDataIsClient = isClient;
        this.cachedAtReloadCount = reloadCount;
    }
}

