/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.excavator;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.excavator.MineralWorldInfo;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public class ExcavatorHandler {
    private static final Multimap<ResourceKey<Level>, MineralVein> MINERAL_VEIN_LIST = ArrayListMultimap.create();
    private static final Map<Pair<ResourceKey<Level>, ColumnPos>, MineralWorldInfo> MINERAL_INFO_CACHE = new HashMap<Pair<ResourceKey<Level>, ColumnPos>, MineralWorldInfo>();
    static final SetRestrictedField<Runnable> MARK_SAVE_DATA_DIRTY = SetRestrictedField.common();
    public static int mineralVeinYield = 0;
    public static double initialVeinDepletion = 0.0;
    public static double mineralNoiseThreshold = 0.0;
    public static PerlinSimplexNoise noiseGenerator;

    @Nullable
    public static MineralVein getRandomMineral(Level world, BlockPos pos) {
        if (world.isClientSide) {
            return null;
        }
        MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(world, pos);
        return info.getMineralVein(ApiUtils.RANDOM);
    }

    public static Multimap<ResourceKey<Level>, MineralVein> getMineralVeinList() {
        return MINERAL_VEIN_LIST;
    }

    public static MineralWorldInfo getMineralWorldInfo(Level world, BlockPos pos) {
        return ExcavatorHandler.getMineralWorldInfo(world, new ColumnPos(pos.getX(), pos.getZ()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MineralWorldInfo getMineralWorldInfo(Level world, ColumnPos columnPos) {
        if (world.isClientSide) {
            return null;
        }
        ResourceKey dimension = world.dimension();
        Pair cacheKey = Pair.of((Object)dimension, (Object)columnPos);
        Multimap<ResourceKey<Level>, MineralVein> multimap = MINERAL_VEIN_LIST;
        synchronized (multimap) {
            MineralWorldInfo worldInfo = MINERAL_INFO_CACHE.get(cacheKey);
            if (worldInfo == null) {
                ArrayList<Pair> inVeins = new ArrayList<Pair>();
                double totalSaturation = 0.0;
                for (MineralVein vein : MINERAL_VEIN_LIST.get((Object)dimension)) {
                    double rSq;
                    long dZ;
                    long dX = vein.getPos().x() - columnPos.x();
                    long d = dX * dX + (dZ = (long)(vein.getPos().z() - columnPos.z())) * dZ;
                    if (!((double)d < (rSq = (double)(vein.getRadius() * vein.getRadius())))) continue;
                    double saturation = 1.0 - (double)d / rSq;
                    inVeins.add(Pair.of((Object)vein, (Object)saturation));
                    totalSaturation += saturation;
                }
                double finalTotalSaturation = totalSaturation;
                worldInfo = new MineralWorldInfo(inVeins.stream().map(pair -> Pair.of((Object)((MineralVein)pair.getFirst()), (Object)((int)((Double)pair.getSecond() / finalTotalSaturation * 1000.0)))).filter(p -> ((MineralVein)p.getFirst()).getMineral(world) != null).collect(Collectors.toList()));
                MINERAL_INFO_CACHE.put((Pair<ResourceKey<Level>, ColumnPos>)cacheKey, worldInfo);
            }
            return worldInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MineralVein> findVeinsForVillager(Level world, BlockPos villagerPos, long radius, List<Long> excludedPositions) {
        List<MineralVein> foundVeins;
        if (world.isClientSide) {
            return Collections.emptyList();
        }
        long radiusSq = radius * radius;
        ResourceKey dimension = world.dimension();
        Multimap<ResourceKey<Level>, MineralVein> multimap = MINERAL_VEIN_LIST;
        synchronized (multimap) {
            foundVeins = MINERAL_VEIN_LIST.get((Object)dimension).stream().filter(vein -> !excludedPositions.contains(vein.getPos().toLong())).filter(vein -> {
                long dZ;
                long dX = vein.getPos().x() - villagerPos.getX();
                long d = dX * dX + (dZ = (long)(vein.getPos().z() - villagerPos.getZ())) * dZ;
                return d < radiusSq;
            }).sorted(Comparator.comparingInt(o -> o.getMineral((Level)world).weight)).collect(Collectors.toList());
        }
        return foundVeins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generatePotentialVein(Level world, WorldGenLevel worldGenLevel, ChunkPos chunkpos, RandomSource rand) {
        int xStart = chunkpos.getMinBlockX();
        int zStart = chunkpos.getMinBlockZ();
        double d0 = 0.0625;
        ColumnPos pos = null;
        double maxNoise = 0.0;
        for (int xx = 0; xx < 16; ++xx) {
            for (int zz = 0; zz < 16; ++zz) {
                double noise = noiseGenerator.getValue((double)(xStart + xx) * d0, (double)(zStart + zz) * d0, true) * 0.55;
                double chance = Math.abs(noise) / 0.55;
                if (!(chance > mineralNoiseThreshold) || !(chance > maxNoise)) continue;
                pos = new ColumnPos(xStart + xx, zStart + zz);
                maxNoise = chance;
            }
        }
        if (pos != null) {
            Multimap<ResourceKey<Level>, MineralVein> multimap = MINERAL_VEIN_LIST;
            synchronized (multimap) {
                ColumnPos finalPos = pos;
                int radius = 12 + rand.nextInt(32);
                int radiusSq = radius * radius;
                boolean crossover = MINERAL_VEIN_LIST.get((Object)world.dimension()).stream().anyMatch(vein -> {
                    long dZ;
                    long dX = vein.getPos().x() - finalPos.x();
                    long dSq = dX * dX + (dZ = (long)(vein.getPos().z() - finalPos.z())) * dZ;
                    return dSq < (long)(vein.getRadius() * vein.getRadius()) || dSq < (long)radiusSq;
                });
                if (!crossover) {
                    RecipeHolder<MineralMix> mineralMix = null;
                    HashSet<Holder<Biome>> biomes = new HashSet<Holder<Biome>>();
                    BiomeManager biomeManager = worldGenLevel.getBiomeManager();
                    int surfaceHeight = worldGenLevel.getHeight(Heightmap.Types.WORLD_SURFACE_WG, finalPos.x(), finalPos.z());
                    for (int i = worldGenLevel.getMinBuildHeight(); i <= surfaceHeight; ++i) {
                        biomes.add((Holder<Biome>)biomeManager.getNoiseBiomeAtPosition((double)pos.x(), (double)i, (double)pos.z()));
                    }
                    MineralSelection selection = new MineralSelection(world, biomes);
                    if (selection.getTotalWeight() > 0) {
                        int weight = selection.getRandomWeight(rand);
                        for (RecipeHolder<MineralMix> e : selection.getMinerals()) {
                            if ((weight -= ((MineralMix)e.value()).weight) >= 0) continue;
                            mineralMix = e;
                            break;
                        }
                    }
                    if (mineralMix != null) {
                        MineralVein vein2 = new MineralVein(pos, mineralMix.id(), radius);
                        if (initialVeinDepletion > 0.0) {
                            vein2.setDepletion((int)((double)mineralVeinYield * (rand.nextDouble() * initialVeinDepletion)));
                        }
                        ExcavatorHandler.addVein((ResourceKey<Level>)world.dimension(), vein2);
                        MARK_SAVE_DATA_DIRTY.get().run();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVein(ResourceKey<Level> dimension, MineralVein vein) {
        Multimap<ResourceKey<Level>, MineralVein> multimap = MINERAL_VEIN_LIST;
        synchronized (multimap) {
            MINERAL_VEIN_LIST.put(dimension, (Object)vein);
            ExcavatorHandler.resetCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCache() {
        Multimap<ResourceKey<Level>, MineralVein> multimap = MINERAL_VEIN_LIST;
        synchronized (multimap) {
            MINERAL_INFO_CACHE.clear();
        }
    }

    public static void setSetDirtyCallback(Runnable setDirty) {
        MARK_SAVE_DATA_DIRTY.setValue(setDirty);
    }

    public static class MineralSelection {
        private final int totalWeight;
        private final Set<RecipeHolder<MineralMix>> validMinerals;

        public MineralSelection(Level world, Set<Holder<Biome>> biomes) {
            int weight = 0;
            this.validMinerals = new HashSet<RecipeHolder<MineralMix>>();
            for (RecipeHolder<MineralMix> e : MineralMix.RECIPES.getRecipes(world)) {
                if (!biomes.stream().anyMatch(biome -> ((MineralMix)e.value()).validBiome((Holder<Biome>)biome))) continue;
                this.validMinerals.add(e);
                weight += ((MineralMix)e.value()).weight;
            }
            this.totalWeight = weight;
        }

        public int getTotalWeight() {
            return this.totalWeight;
        }

        public int getRandomWeight(RandomSource random) {
            return random.nextInt(this.totalWeight);
        }

        public Set<RecipeHolder<MineralMix>> getMinerals() {
            return this.validMinerals;
        }
    }
}

