/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ItemUtils {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static CompoundTag parseNbtFromJson(JsonElement jsonElement) throws CommandSyntaxException {
        if (jsonElement.isJsonObject()) {
            return TagParser.parseTag((String)GSON.toJson(jsonElement));
        }
        return TagParser.parseTag((String)jsonElement.getAsString());
    }

    public static HumanoidArm getLivingHand(LivingEntity living, InteractionHand hand) {
        HumanoidArm handside = living.getMainArm();
        if (hand != InteractionHand.MAIN_HAND) {
            handside = handside == HumanoidArm.LEFT ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
        }
        return handside;
    }

    public static Optional<Pair<EquippedItem, EquippedItem>> isHoldingBoth(Player player, TagKey<Item> tag1, TagKey<Item> tag2) {
        return ItemUtils.isHoldingBoth(player, (ItemStack s) -> s.is(tag1), (ItemStack s) -> s.is(tag2));
    }

    public static Optional<Pair<EquippedItem, EquippedItem>> isHoldingBoth(Player player, Predicate<ItemStack> check1, Predicate<ItemStack> check2) {
        if (check1.test(player.getMainHandItem()) && check2.test(player.getOffhandItem())) {
            return Optional.of(Pair.of((Object)new EquippedItem(EquipmentSlot.MAINHAND, player.getMainHandItem()), (Object)new EquippedItem(EquipmentSlot.OFFHAND, player.getOffhandItem())));
        }
        if (check1.test(player.getOffhandItem()) && check2.test(player.getMainHandItem())) {
            return Optional.of(Pair.of((Object)new EquippedItem(EquipmentSlot.OFFHAND, player.getOffhandItem()), (Object)new EquippedItem(EquipmentSlot.MAINHAND, player.getMainHandItem())));
        }
        return Optional.empty();
    }

    public static void tryInsertEntity(Level level, BlockPos pos, Direction side, ItemEntity toInsert) {
        IItemHandler itemHandler = CapabilityUtils.findItemHandlerAtPos(level, pos, side, true);
        if (itemHandler == null) {
            return;
        }
        ItemStack stack = toInsert.getItem();
        ItemStack temp = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)true);
        if (temp.getCount() < stack.getCount()) {
            temp = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
            if (temp.isEmpty()) {
                toInsert.discard();
            } else if (temp.getCount() < stack.getCount()) {
                toInsert.setItem(temp);
            }
        }
    }

    public static boolean isSameIgnoreDurability(ItemStack stackA, ItemStack stackB) {
        if (stackA == stackB) {
            return true;
        }
        if (stackA.isEmpty() != stackB.isEmpty()) {
            return false;
        }
        if (stackA.isEmpty()) {
            return true;
        }
        if (!stackA.is(stackB.getItem())) {
            return false;
        }
        if (!stackA.isDamageableItem()) {
            return true;
        }
        return stackA.getDamageValue() == stackB.getDamageValue();
    }

    public static ItemStack damageCopy(ItemStack tool, int amount) {
        ItemStack copy = tool.copy();
        ItemUtils.damageDirect(copy, amount);
        return copy;
    }

    public static void damageDirect(ItemStack tool, int amount) {
        int maxDamage = tool.getMaxDamage();
        int newDamage = tool.getDamageValue() + amount;
        if (newDamage > maxDamage) {
            tool.setDamageValue(0);
            tool.shrink(1);
        } else {
            tool.setDamageValue(newDamage);
        }
    }

    public static void damageStackableItem(ItemStack stack, Level level, int amount) {
        if (!stack.has(DataComponents.DAMAGE)) {
            stack.set(DataComponents.DAMAGE, (Object)0);
        }
        stack.hurtAndBreak(amount, (ServerLevel)level, null, item -> {});
    }

    public record EquippedItem(EquipmentSlot slot, ItemStack stack) {
    }
}

