/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.block;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.ieobj.BlockCallback;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.metal.ChuteBlockEntity;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.collect.ImmutableList;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;

public class ChuteCallbacks
implements BlockCallback<Key> {
    public static final ChuteCallbacks INSTANCE = new ChuteCallbacks();
    private static final Key INVALID = new Key(false, Direction.NORTH, (List<Direction>)ImmutableList.of());

    @Override
    public Key extractKey(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, BlockEntity blockEntity) {
        if (!(blockEntity instanceof ChuteBlockEntity)) {
            return this.getDefaultKey();
        }
        ChuteBlockEntity chuteBE = (ChuteBlockEntity)blockEntity;
        ArrayList<Direction> solidWalls = new ArrayList<Direction>();
        for (Direction dir : DirectionUtils.BY_HORIZONTAL_INDEX) {
            if (chuteBE.isInwardConveyor(dir)) continue;
            solidWalls.add(dir);
        }
        return new Key(chuteBE.isDiagonal(), chuteBE.getFacing(), solidWalls);
    }

    @Override
    public Key getDefaultKey() {
        return INVALID;
    }

    @Override
    public IEProperties.IEObjState getIEOBJState(Key key) {
        if (key.diagonal()) {
            Matrix4f matrix = new Matrix4(key.facing().getOpposite()).toMatrix4f();
            return new IEProperties.IEObjState(IEProperties.VisibilityList.show("diagonal"), new Transformation(matrix));
        }
        ArrayList<String> walls = new ArrayList<String>(key.solidWalls().stream().map(d -> d.name().toLowerCase(Locale.US)).toList());
        walls.add("base");
        return new IEProperties.IEObjState(IEProperties.VisibilityList.show(walls));
    }

    public record Key(boolean diagonal, Direction facing, List<Direction> solidWalls) {
    }
}

