/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.IEShaderLayerCompositeTexture;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerBlockEntity;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerStandingBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerWallBlock;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class ShaderBannerRenderer
extends IEBlockEntityRenderer<ShaderBannerBlockEntity> {
    private final ModelPart clothModel;
    private final ModelPart standingModel;
    private final ModelPart crossbar;
    private static final ResourceLocation BASE_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/banner_base.png");
    private static final HashMap<ResourceLocation, ResourceLocation> CACHE = new HashMap();

    public ShaderBannerRenderer(BlockEntityRendererProvider.Context ctx) {
        ModelPart modelpart = ctx.bakeLayer(ModelLayers.BANNER);
        this.clothModel = modelpart.getChild("flag");
        this.standingModel = modelpart.getChild("pole");
        this.crossbar = modelpart.getChild("bar");
    }

    public void render(ShaderBannerBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        long time = te.getLevelNonnull().getGameTime();
        matrixStack.pushPose();
        if (te.getState().getBlock() == IEBlocks.Cloth.SHADER_BANNER.get()) {
            int orientation = (Integer)te.getState().getValue((Property)ShaderBannerStandingBlock.ROTATION);
            matrixStack.translate(0.5f, 0.5f, 0.5f);
            float f1 = (float)(orientation * 360) / 16.0f;
            matrixStack.mulPose(new Quaternionf().rotateY(-f1 * ((float)Math.PI / 180)));
            this.standingModel.visible = true;
        } else {
            assert (te.getState().getBlock() == IEBlocks.Cloth.SHADER_BANNER_WALL.get());
            Direction facing = (Direction)te.getState().getValue(ShaderBannerWallBlock.FACING);
            float rotation = facing.toYRot();
            matrixStack.translate(0.5f, -0.16666667f, 0.5f);
            matrixStack.mulPose(new Quaternionf().rotateY(-rotation * ((float)Math.PI / 180)));
            matrixStack.translate(0.0f, -0.3125f, -0.4375f);
            this.standingModel.visible = false;
        }
        BlockPos blockpos = te.getBlockPos();
        float f3 = (float)(blockpos.getX() * 7 + blockpos.getY() * 9 + blockpos.getZ() * 13) + (float)time + partialTicks;
        this.clothModel.xRot = (-0.0125f + 0.01f * Mth.cos((float)(f3 * (float)Math.PI * 0.02f))) * (float)Math.PI;
        this.clothModel.y = -32.0f;
        ResourceLocation resourcelocation = this.getBannerResourceLocation(te);
        if (resourcelocation != null) {
            matrixStack.pushPose();
            matrixStack.scale(0.6666667f, -0.6666667f, -0.6666667f);
            VertexConsumer builder = bufferIn.getBuffer(RenderType.entitySolid((ResourceLocation)resourcelocation));
            this.clothModel.render(matrixStack, builder, combinedLightIn, combinedOverlayIn);
            builder = ModelBakery.BANNER_BASE.buffer(bufferIn, RenderType::entitySolid);
            this.crossbar.render(matrixStack, builder, combinedLightIn, combinedOverlayIn);
            this.standingModel.render(matrixStack, builder, combinedLightIn, combinedOverlayIn);
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }

    @Nullable
    private ResourceLocation getBannerResourceLocation(ShaderBannerBlockEntity bannerObj) {
        return ShaderBannerRenderer.getShaderResourceLocation(bannerObj.shader.getShader(), bannerObj.shader.getShaderType());
    }

    @Nullable
    public static ResourceLocation getShaderResourceLocation(ResourceLocation shader, ResourceLocation shaderType) {
        ShaderCase sCase = ShaderRegistry.getShader(shader, shaderType);
        if (sCase != null) {
            ShaderLayer[] layers = sCase.getLayers();
            ResourceLocation textureLocation = shader.withPath("bannershader/" + shader.getPath());
            ClientUtils.mc().getTextureManager().register(textureLocation, (AbstractTexture)new IEShaderLayerCompositeTexture(BASE_TEXTURE, layers));
            CACHE.put(shader, textureLocation);
            return textureLocation;
        }
        return null;
    }
}

