/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.common;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import owmii.powah.Powah;
import owmii.powah.api.PassiveHeatSourceConfig;

public record PassiveHeatSource(ResourceLocation id, @Nullable Block block, @Nullable Fluid fluid, int heat) {
    public static List<PassiveHeatSource> getAll() {
        ResourceLocation recipeId;
        int heat;
        ResourceLocation id;
        ArrayList<PassiveHeatSource> result = new ArrayList<PassiveHeatSource>();
        for (Map.Entry entry : BuiltInRegistries.BLOCK.getDataMap(PassiveHeatSourceConfig.BLOCK_DATA_MAP).entrySet()) {
            id = ((ResourceKey)entry.getKey()).location();
            heat = ((PassiveHeatSourceConfig)entry.getValue()).temperature();
            Block block = (Block)BuiltInRegistries.BLOCK.get(id);
            recipeId = Powah.id("passive_heat_source/block/" + id.getNamespace() + "/" + id.getPath());
            result.add(new PassiveHeatSource(recipeId, block, null, heat));
        }
        for (Map.Entry entry : BuiltInRegistries.FLUID.getDataMap(PassiveHeatSourceConfig.FLUID_DATA_MAP).entrySet()) {
            id = ((ResourceKey)entry.getKey()).location();
            heat = ((PassiveHeatSourceConfig)entry.getValue()).temperature();
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(id);
            if (!fluid.isSource(fluid.defaultFluidState())) continue;
            recipeId = Powah.id("passive_heat_source/fluid/" + id.getNamespace() + "/" + id.getPath());
            result.add(new PassiveHeatSource(recipeId, null, fluid, heat));
        }
        result.sort(Comparator.comparingInt(PassiveHeatSource::heat));
        return result;
    }
}

