/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.mixin.patch.item;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.darkhax.bookshelf.common.api.item.IItemHooks;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.bookshelf.common.impl.Constants;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CreativeModeTab.class})
public class MixinCreativeModeTab {
    @Shadow
    private Collection<ItemStack> displayItems;
    @Shadow
    private Set<ItemStack> displayItemsSearchTab;
    @Unique
    private static final Map<ResourceLocation, TagKey<Item>> TAG_CACHE = new HashMap<ResourceLocation, TagKey<Item>>();
    @Unique
    private static final ResourceLocation OP_ITEMS_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"op_blocks");

    @Inject(method={"buildContents(Lnet/minecraft/world/item/CreativeModeTab$ItemDisplayParameters;)V"}, at={@At(value="TAIL")})
    private void buildContents(CreativeModeTab.ItemDisplayParameters parameters, CallbackInfo cbi) {
        CreativeModeTab self = (CreativeModeTab)this;
        ResourceLocation id = BuiltInRegistries.CREATIVE_MODE_TAB.getKey((Object)self);
        if (!(id == null || self.isAlignedRight() && !id.equals((Object)OP_ITEMS_ID) || id.equals((Object)OP_ITEMS_ID) && !parameters.hasPermissions())) {
            TagKey tabTag = TAG_CACHE.computeIfAbsent(id, key -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Constants.id("creative_tab/" + key.getNamespace() + "/" + key.getPath())));
            for (Holder tagEntry : DataHelper.getTagOrEmpty(parameters.holders(), Registries.ITEM, tabTag)) {
                try {
                    Item item = (Item)tagEntry.value();
                    if (item instanceof IItemHooks) {
                        IItemHooks hooks = (IItemHooks)item;
                        hooks.addCreativeTabForms(self, stack -> {
                            this.displayItems.add((ItemStack)stack);
                            this.displayItemsSearchTab.add((ItemStack)stack);
                        });
                        continue;
                    }
                    ItemStack stack2 = new ItemStack((ItemLike)item);
                    this.displayItems.add(stack2);
                    this.displayItemsSearchTab.add(stack2);
                }
                catch (Exception e) {
                    Constants.LOG.error("Unable to add tag entries to creative tab!", (Throwable)e);
                }
            }
        }
    }
}

