/*
 * Decompiled with CFR 0.152.
 */
package com.github.bigenergy.glassential.client.model;

import com.github.bigenergy.glassential.blocks.OneWayGlassBlock;
import com.github.bigenergy.glassential.blocks.entity.OneWayGlassBlockEntity;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OneWayBakedModel
implements BakedModel {
    private final BakedModel glassModel;

    public OneWayBakedModel(BakedModel glassModel) {
        this.glassModel = glassModel;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType layer) {
        if (state == null || side == null) {
            return Collections.emptyList();
        }
        Direction opaque = (Direction)state.getValue((Property)OneWayGlassBlock.OPAQUE_FACE);
        if (side != opaque) {
            return this.glassModel.getQuads(state, side, rand, data, layer);
        }
        BlockState mimic = (BlockState)data.get(OneWayGlassBlockEntity.MIMIC);
        if (mimic == null) {
            return this.glassModel.getQuads(state, side, rand, data, layer);
        }
        BakedModel mimicModel = Minecraft.getInstance().getBlockRenderer().getBlockModel(mimic);
        List quads = mimicModel.getQuads(mimic, side, rand, ModelData.EMPTY, layer);
        if (quads.isEmpty()) {
            quads = mimicModel.getQuads(mimic, side, rand, ModelData.EMPTY, null);
        }
        return quads;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState s, @Nullable Direction side, RandomSource r) {
        return Collections.emptyList();
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return this.glassModel.getRenderTypes(state, rand, data);
    }

    public boolean useAmbientOcclusion() {
        return this.glassModel.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.glassModel.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.glassModel.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.glassModel.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.glassModel.getParticleIcon();
    }

    public ItemTransforms getTransforms() {
        return this.glassModel.getTransforms();
    }

    public ItemOverrides getOverrides() {
        return this.glassModel.getOverrides();
    }
}

