/*
 * Decompiled with CFR 0.152.
 */
package com.omnitools.omniTools.core;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.registries.holdersets.AnyHolderSet;

public class OmniVajraItem
extends Item {
    private static final String MINING_SPEED_TAG = "VajraMiningSpeed";
    private static final String AUTO_PICKUP_TAG = "VajraAutoPickupEnabled";
    private static final float MIN_MINING_SPEED = 1.0f;
    private static final float MAX_MINING_SPEED = 1000.0f;
    private static final Set<ItemAbility> MY_ABILITIES = Set.of(ItemAbilities.AXE_STRIP, ItemAbilities.AXE_SCRAPE, ItemAbilities.AXE_WAX_OFF, ItemAbilities.SHOVEL_FLATTEN, ItemAbilities.SHOVEL_DOUSE);

    public OmniVajraItem(Item.Properties properties) {
        super(properties.component(DataComponents.TOOL, (Object)OmniVajraItem.createToolProperties()));
    }

    private static Tool createToolProperties() {
        return new Tool(List.of(Tool.Rule.deniesDrops((TagKey)Tiers.NETHERITE.getIncorrectBlocksForDrops()), new Tool.Rule((HolderSet)new AnyHolderSet(BuiltInRegistries.BLOCK.asLookup()), Optional.empty(), Optional.of(true))), Tiers.NETHERITE.getSpeed(), 0);
    }

    public static float getMiningSpeed(ItemStack stack) {
        CompoundTag tag;
        if (stack.isEmpty()) {
            return Tiers.NETHERITE.getSpeed();
        }
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData != null && (tag = customData.copyTag()).contains(MINING_SPEED_TAG)) {
            return tag.getFloat(MINING_SPEED_TAG);
        }
        return Tiers.NETHERITE.getSpeed();
    }

    public static void setMiningSpeed(ItemStack stack, float speed) {
        if (stack.isEmpty()) {
            return;
        }
        float clamped = Math.max(1.0f, Math.min(1000.0f, speed));
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        tag.putFloat(MINING_SPEED_TAG, clamped);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public static boolean isAutoPickupEnabled(ItemStack stack) {
        CompoundTag tag;
        if (stack.isEmpty()) {
            return true;
        }
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData != null && (tag = customData.copyTag()).contains(AUTO_PICKUP_TAG)) {
            return tag.getBoolean(AUTO_PICKUP_TAG);
        }
        return true;
    }

    public static void setAutoPickupEnabled(ItemStack stack, boolean enabled) {
        if (stack.isEmpty()) {
            return;
        }
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        tag.putBoolean(AUTO_PICKUP_TAG, enabled);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    private static void toggleAutoPickup(ItemStack stack, Level level, Player player) {
        if (level.isClientSide) {
            return;
        }
        boolean enabled = !OmniVajraItem.isAutoPickupEnabled(stack);
        OmniVajraItem.setAutoPickupEnabled(stack, enabled);
        player.displayClientMessage((Component)Component.translatable((String)"message.omnitools.vajra_pickup_mode", (Object[])new Object[]{Component.translatable((String)(enabled ? "message.omnitools.vajra_pickup_mode_on" : "message.omnitools.vajra_pickup_mode_off"))}), true);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return OmniVajraItem.getMiningSpeed(stack);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility ability) {
        return MY_ABILITIES.contains(ability) || super.canPerformAction(stack, ability);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            OmniVajraItem.toggleAutoPickup(stack, level, player);
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        }
        return super.use(level, player, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        BlockState modifiedState = null;
        SoundEvent sound = null;
        int levelEventId = -1;
        if (stack.canPerformAction(ItemAbilities.AXE_STRIP) && (modifiedState = state.getToolModifiedState(context, ItemAbilities.AXE_STRIP, false)) != null) {
            sound = SoundEvents.AXE_STRIP;
        }
        if (modifiedState == null && stack.canPerformAction(ItemAbilities.AXE_SCRAPE) && (modifiedState = state.getToolModifiedState(context, ItemAbilities.AXE_SCRAPE, false)) != null) {
            sound = SoundEvents.AXE_SCRAPE;
            levelEventId = 3005;
        }
        if (modifiedState == null && stack.canPerformAction(ItemAbilities.AXE_WAX_OFF) && (modifiedState = state.getToolModifiedState(context, ItemAbilities.AXE_WAX_OFF, false)) != null) {
            sound = SoundEvents.AXE_WAX_OFF;
            levelEventId = 3004;
        }
        if (modifiedState == null && stack.canPerformAction(ItemAbilities.SHOVEL_FLATTEN) && (modifiedState = state.getToolModifiedState(context, ItemAbilities.SHOVEL_FLATTEN, false)) != null) {
            sound = SoundEvents.SHOVEL_FLATTEN;
        }
        if (modifiedState == null && stack.canPerformAction(ItemAbilities.SHOVEL_DOUSE) && (modifiedState = state.getToolModifiedState(context, ItemAbilities.SHOVEL_DOUSE, false)) != null) {
            sound = SoundEvents.FIRE_EXTINGUISH;
            if (state.getBlock() instanceof CampfireBlock && state.hasProperty((Property)CampfireBlock.LIT) && ((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                CampfireBlock.dowse((Entity)player, (LevelAccessor)level, (BlockPos)pos, (BlockState)state);
            }
        }
        if (modifiedState == null || sound == null) {
            return super.useOn(context);
        }
        level.playSound(player, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!level.isClientSide) {
            level.setBlock(pos, modifiedState, 11);
            if (levelEventId != -1) {
                level.levelEvent(player, levelEventId, pos, 0);
            }
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            if (player != null) {
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!OmniVajraItem.isAutoPickupEnabled(stack)) {
            return super.mineBlock(stack, level, state, pos, entity);
        }
        if (!(level instanceof ServerLevel)) {
            return true;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            List drops = Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)stack);
            for (ItemStack drop : drops) {
                if (player.getInventory().add(drop)) continue;
                player.drop(drop, false);
            }
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            return true;
        }
        return super.mineBlock(stack, level, state, pos, entity);
    }
}

