/*
 * Decompiled with CFR 0.152.
 */
package com.omnitools.omniTools.network;

import com.omnitools.omniTools.core.ModItems;
import com.omnitools.omniTools.core.OmniVajraItem;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncVajraMiningSpeedPacket(float miningSpeed) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"omnitools", (String)"sync_vajra_mining_speed");
    public static final CustomPacketPayload.Type<SyncVajraMiningSpeedPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<ByteBuf, SyncVajraMiningSpeedPacket> CODEC = ByteBufCodecs.FLOAT.map(SyncVajraMiningSpeedPacket::new, SyncVajraMiningSpeedPacket::miningSpeed);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player == null) {
                return;
            }
            ItemStack mainHandStack = player.getMainHandItem();
            if (mainHandStack.getItem() == ModItems.OMNI_VAJRA.get()) {
                OmniVajraItem.setMiningSpeed(mainHandStack, this.miningSpeed);
            }
        });
    }
}

