/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import me.drex.villagerconfig.common.VillagerConfig;
import me.drex.villagerconfig.common.platform.PlatformHooks;
import me.drex.villagerconfig.common.util.TradeProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.data.DataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.world.flag.FeatureFlags;

public class GenerateCommand {
    private static final Path GENERATED = PlatformHooks.PLATFORM_HELPER.getModConfigDir().resolve("generated");

    public static LiteralArgumentBuilder<CommandSourceStack> builder() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"generate").then(Commands.argument((String)"experimental", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> GenerateCommand.execute((CommandSourceStack)ctx.getSource(), BoolArgumentType.getBool((CommandContext)ctx, (String)"experimental"))))).executes(ctx -> GenerateCommand.execute((CommandSourceStack)ctx.getSource(), false));
    }

    private static int execute(CommandSourceStack src, boolean experimental) {
        DataGenerator dataGenerator = new DataGenerator(GENERATED, SharedConstants.getCurrentVersion(), true);
        DataGenerator.PackGenerator tradesPack = dataGenerator.getVanillaPack(true);
        if (experimental && !src.getLevel().enabledFeatures().contains(FeatureFlags.TRADE_REBALANCE)) {
            src.sendFailure((Component)Component.literal((String)"You need to enable experimental trade rebalance datapack to generate experimental trades"));
            return 0;
        }
        tradesPack.addProvider(packOutput -> new TradeProvider(packOutput, CompletableFuture.completedFuture(src.getServer().registryAccess()), experimental, FeatureFlags.VANILLA_SET));
        try {
            dataGenerator.run();
            src.sendSuccess(() -> Component.literal((String)("Successfully generated trade " + (experimental ? "(experimental) " : "") + "data to " + String.valueOf(GENERATED))).withStyle(ChatFormatting.GREEN), false);
            return 1;
        }
        catch (Throwable e) {
            src.sendFailure((Component)Component.literal((String)"An error occurred, please look into the console for more information."));
            VillagerConfig.LOGGER.error("An error occurred, while generating trade data", e);
            return 0;
        }
    }
}

