/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.util;

import me.drex.villagerconfig.common.VillagerConfig;
import me.drex.villagerconfig.common.data.TradeTable;
import me.drex.villagerconfig.common.mixin.VillagerDataAccessor;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;

public class CustomVillagerData {
    public static TradeTable getTradeTable(Villager villager) {
        if (villager.level() instanceof ServerLevel) {
            ResourceLocation identifier = BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)villager.getVillagerData().getProfession());
            return VillagerConfig.TRADE_MANAGER.getTrade(identifier);
        }
        return null;
    }

    public static int getMaxLevel(Villager villager) {
        TradeTable tradeTable = CustomVillagerData.getTradeTable(villager);
        if (tradeTable != null) {
            return tradeTable.maxLevel();
        }
        return 5;
    }

    public static int[] getNextLevelXpThresholds(Villager villager) {
        TradeTable tradeTable = CustomVillagerData.getTradeTable(villager);
        if (tradeTable != null) {
            int[] nextLevelXpThresholds = new int[tradeTable.maxLevel()];
            for (int i = 0; i < tradeTable.maxLevel(); ++i) {
                nextLevelXpThresholds[i] = tradeTable.requiredExperience(i + 1);
            }
            return nextLevelXpThresholds;
        }
        return VillagerDataAccessor.getNextLevelXpThresholds();
    }

    public static int getMinXpPerLevel(Villager villager, int level) {
        TradeTable tradeTable = CustomVillagerData.getTradeTable(villager);
        if (tradeTable != null) {
            return tradeTable.requiredExperience(level);
        }
        return VillagerData.getMinXpPerLevel((int)level);
    }

    public static int getMaxXpPerLevel(Villager villager, int level) {
        TradeTable tradeTable = CustomVillagerData.getTradeTable(villager);
        if (tradeTable != null) {
            return tradeTable.requiredExperience(level + 1);
        }
        return VillagerData.getMaxXpPerLevel((int)level);
    }

    public static boolean canLevelUp(Villager villager, int level) {
        TradeTable tradeTable = CustomVillagerData.getTradeTable(villager);
        if (tradeTable != null) {
            int maxLevel = tradeTable.maxLevel();
            return level >= 1 && level < maxLevel;
        }
        return VillagerData.canLevelUp((int)level);
    }
}

