/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import me.drex.villagerconfig.common.VillagerConfig;
import me.drex.villagerconfig.common.data.TradeTable;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class TradeManager
extends SimpleJsonResourceReloadListener {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"villagerconfig", (String)"trades");
    private static final Logger LOGGER = VillagerConfig.LOGGER;
    private Map<ResourceLocation, TradeTable> trades = ImmutableMap.of();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final HolderLookup.Provider provider;

    public TradeManager(HolderLookup.Provider provider) {
        super(GSON, "trades");
        this.provider = provider;
    }

    @Nullable
    public TradeTable getTrade(ResourceLocation id) {
        return this.trades.get(id);
    }

    protected void apply(Map<ResourceLocation, JsonElement> prepared, ResourceManager manager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        prepared.forEach((identifier, jsonElement) -> {
            try {
                TradeTable table = (TradeTable)TradeTable.CODEC.parse(this.registryOps(), jsonElement).getOrThrow();
                builder.put(identifier, (Object)table);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to load trade {}", identifier, (Object)exception);
            }
        });
        this.trades = builder.build();
        LOGGER.info("Loaded {} trades", (Object)this.trades.size());
    }

    public RegistryOps<JsonElement> registryOps() {
        return this.provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
    }
}

