/*
 * Decompiled with CFR 0.152.
 */
package vazkii.morphtool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import vazkii.morphtool.ConfigHandler;
import vazkii.morphtool.MorphTool;
import vazkii.morphtool.MorphingHandler;
import vazkii.morphtool.Registries;
import vazkii.morphtool.data_components.ToolContentComponent;
import vazkii.morphtool.network.MessageMorphTool;
import vazkii.morphtool.network.NetworkHandler;

@OnlyIn(value=Dist.CLIENT)
public class ClientHandler {
    public static final ClientHandler INSTANCE = new ClientHandler();
    protected static boolean autoMode = true;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTick(ClientTickEvent.Post event) {
        ItemStack mainHandItem;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && autoMode && MorphingHandler.isMorphTool(mainHandItem = player.getItemInHand((Boolean)ConfigHandler.invertHandShift.get() != false ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND))) {
            ItemStack newStack = mainHandItem;
            HitResult res = MorphingHandler.raycast((Entity)player, 4.5);
            if (res != null && res.getType() == HitResult.Type.BLOCK) {
                BlockState state = player.level().getBlockState(((BlockHitResult)res).getBlockPos());
                String modlook = MorphingHandler.getModFromState(state);
                newStack = MorphingHandler.getShiftStackForMod(mainHandItem, modlook);
            }
            if (newStack != mainHandItem && !ItemStack.isSameItemSameComponents((ItemStack)newStack, (ItemStack)mainHandItem)) {
                Inventory inventory = player.getInventory();
                inventory.setItem((Boolean)ConfigHandler.invertHandShift.get() != false ? inventory.getContainerSize() - 1 : inventory.selected, newStack);
                NetworkHandler.sendToServer(new MessageMorphTool(newStack, inventory.selected));
                MorphTool.proxy.updateEquippedItem();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMouseEvent(InputEvent.MouseScrollingEvent event) {
        ItemStack mainHandItem;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && MorphingHandler.isMorphTool(mainHandItem = player.getItemInHand((Boolean)ConfigHandler.invertHandShift.get() != false ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND))) {
            ItemStack newStack = mainHandItem;
            String mod = MorphingHandler.getModFromStack(mainHandItem);
            HitResult res = MorphingHandler.raycast((Entity)player, 4.5);
            String modlook = "";
            if (res != null && res.getType() == HitResult.Type.BLOCK) {
                BlockState state = player.level().getBlockState(((BlockHitResult)res).getBlockPos());
                modlook = MorphingHandler.getModFromState(state);
            }
            if (event.getScrollDeltaY() != 0.0 && player.isCrouching() && !modlook.equals(mod) && mainHandItem.has(Registries.TOOL_CONTENT) && mainHandItem.get(Registries.TOOL_CONTENT) != null) {
                ToolContentComponent contents = (ToolContentComponent)mainHandItem.get(Registries.TOOL_CONTENT);
                mod = event.getScrollDeltaY() < 0.0 ? ClientHandler.nextMod(contents, mod) : ClientHandler.previousMod(contents, mod);
                newStack = MorphingHandler.getShiftStackForMod(mainHandItem, mod);
                autoMode = mod.equals("morphtool");
                event.setCanceled(true);
            }
            if (newStack != mainHandItem && !ItemStack.isSameItemSameComponents((ItemStack)newStack, (ItemStack)mainHandItem)) {
                Inventory inventory = player.getInventory();
                inventory.setItem((Boolean)ConfigHandler.invertHandShift.get() != false ? inventory.getContainerSize() - 1 : inventory.selected, newStack);
                NetworkHandler.sendToServer(new MessageMorphTool(newStack, inventory.selected));
                MorphTool.proxy.updateEquippedItem();
            }
        }
    }

    public static List<String> getModsFromStacks(ToolContentComponent toolContents) {
        ArrayList<String> mods = new ArrayList<String>();
        for (ItemStack stack : toolContents.getItems()) {
            mods.add(MorphingHandler.getModFromStack(stack));
        }
        return mods;
    }

    public static String nextMod(ToolContentComponent toolContents, String mod) {
        List<String> mods = ClientHandler.getModsFromStacks(toolContents);
        mods.add("morphtool");
        if (!mod.equals("morphtool")) {
            mods.add(mod);
        }
        Collections.sort(mods);
        int id = mods.indexOf(mod);
        int retid = 0;
        if (mods.size() > id + 1) {
            retid = id + 1;
        }
        return mods.get(retid);
    }

    public static String previousMod(ToolContentComponent toolContents, String mod) {
        List<String> mods = ClientHandler.getModsFromStacks(toolContents);
        mods.add("morphtool");
        if (!mod.equals("morphtool")) {
            mods.add(mod);
        }
        Collections.sort(mods);
        int id = mods.indexOf(mod);
        int retid = mods.size() - 1;
        if (0 <= id - 1) {
            retid = id - 1;
        }
        return mods.get(retid);
    }
}

