/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.block.tile;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tarantel.chickenroost.block.blocks.ModBlocks;
import net.tarantel.chickenroost.block.tile.InputOutputItemHandler;
import net.tarantel.chickenroost.block.tile.ModBlockEntities;
import net.tarantel.chickenroost.handler.SoulExtractorHandler;
import net.tarantel.chickenroost.item.base.ChickenItemBase;
import net.tarantel.chickenroost.recipes.ModRecipes;
import net.tarantel.chickenroost.recipes.SoulExtractorRecipe;
import net.tarantel.chickenroost.util.Config;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoulExtractorTile
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            SoulExtractorTile.this.setChanged();
            if (slot == 0) {
                SoulExtractorTile.this.resetProgress();
            }
            assert (SoulExtractorTile.this.level != null);
            if (!SoulExtractorTile.this.level.isClientSide()) {
                SoulExtractorTile.this.level.sendBlockUpdated(SoulExtractorTile.this.getBlockPos(), SoulExtractorTile.this.getBlockState(), SoulExtractorTile.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.getItem() instanceof ChickenItemBase;
                case 1 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    protected final ContainerData data;
    public int progress = 0;
    public int maxProgress = (Integer)Config.extractor_speedtimer.get() * 20;
    private final IItemHandler itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1);
    private boolean autoOutput = false;
    private boolean lastRedstonePowered = false;

    public ItemStack getRenderStack() {
        ItemStack stack = !this.itemHandler.getStackInSlot(0).isEmpty() ? this.itemHandler.getStackInSlot(0) : ItemStack.EMPTY;
        return stack;
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    public int getScaledProgress() {
        int progresss = this.progress;
        int maxProgresss = this.maxProgress;
        int progressArrowSize = 200;
        return maxProgresss != 0 && progresss != 0 ? progresss * progressArrowSize / maxProgresss : 0;
    }

    public SoulExtractorTile(BlockPos pos, BlockState state) {
        super(ModBlockEntities.SOUL_EXTRACTOR.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> SoulExtractorTile.this.progress;
                    case 1 -> SoulExtractorTile.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        SoulExtractorTile.this.progress = value;
                        break;
                    }
                    case 1: {
                        SoulExtractorTile.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"name.chicken_roost.soul_extractor_");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player player) {
        return new SoulExtractorHandler(id, inventory, this, this.data);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    public void onLoad() {
        super.onLoad();
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
        this.setChanged();
    }

    public void saveAdditional(CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        nbt.put("inventory", (Tag)this.itemHandler.serializeNBT(lookup));
        nbt.putInt("soul_extractor.progress", this.progress);
        nbt.putBoolean("AutoOutput", this.autoOutput);
        nbt.putBoolean("LastRedstonePowered", this.lastRedstonePowered);
        super.saveAdditional(nbt, lookup);
    }

    public void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        super.loadAdditional(nbt, lookup);
        this.itemHandler.deserializeNBT(lookup, nbt.getCompound("inventory"));
        this.progress = nbt.getInt("soul_extractor.progress");
        this.autoOutput = nbt.contains("AutoOutput") ? nbt.getBoolean("AutoOutput") : false;
        this.lastRedstonePowered = nbt.contains("LastRedstonePowered") ? nbt.getBoolean("LastRedstonePowered") : false;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        SimpleContainer block = new SimpleContainer(1);
        ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.SOUL_EXTRACTOR.get());
        NonNullList items = inventory.getItems();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            items.set(i, (Object)this.itemHandler.getStackInSlot(i));
        }
        itemStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)inventory.getItems()));
        block.setItem(0, itemStack.copy());
        Containers.dropContents((Level)Objects.requireNonNull(this.level), (BlockPos)this.worldPosition, (Container)block);
    }

    public boolean isAutoOutputEnabled() {
        return this.autoOutput;
    }

    public void setAutoOutputEnabled(boolean enabled) {
        this.autoOutput = enabled;
        if (this.level != null && !this.level.isClientSide) {
            SoulExtractorTile.setChanged((Level)this.level, (BlockPos)this.worldPosition, (BlockState)this.getBlockState());
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SoulExtractorTile pEntity) {
        if (level.isClientSide()) {
            return;
        }
        boolean powered = level.hasNeighborSignal(pos);
        if (powered && !pEntity.lastRedstonePowered) {
            pEntity.setAutoOutputEnabled(true);
        }
        pEntity.lastRedstonePowered = powered;
        SoulExtractorTile.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        if (SoulExtractorTile.hasRecipe(pEntity)) {
            ++pEntity.progress;
            if (pEntity.progress >= pEntity.maxProgress) {
                SoulExtractorTile.craftItem(pEntity);
            }
        } else {
            pEntity.resetProgress();
            SoulExtractorTile.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
        if (pEntity.isAutoOutputEnabled()) {
            SoulExtractorTile.tryPushOutputDown(level, pos, state, pEntity);
        }
    }

    private static void tryPushOutputDown(Level level, BlockPos pos, BlockState state, SoulExtractorTile tile) {
        ItemStack outputStack = tile.itemHandler.getStackInSlot(1);
        if (outputStack.isEmpty()) {
            return;
        }
        IItemHandler belowHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos.below(), (Object)Direction.UP);
        if (belowHandler == null) {
            return;
        }
        ItemStack remaining = outputStack.copy();
        for (int slot = 0; slot < belowHandler.getSlots() && !remaining.isEmpty(); ++slot) {
            remaining = belowHandler.insertItem(slot, remaining, false);
        }
        if (remaining.getCount() == outputStack.getCount()) {
            return;
        }
        int moved = outputStack.getCount() - remaining.getCount();
        ItemStack newStack = outputStack.copy();
        newStack.shrink(moved);
        if (newStack.isEmpty()) {
            newStack = ItemStack.EMPTY;
        }
        tile.itemHandler.setStackInSlot(1, newStack);
        SoulExtractorTile.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static void craftItem(SoulExtractorTile pEntity) {
        Level level = pEntity.level;
        SimpleContainer inventory = new SimpleContainer(pEntity.itemHandler.getSlots());
        for (int i = 0; i < pEntity.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, pEntity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = Optional.empty();
        if (level != null) {
            recipe = level.getRecipeManager().getRecipeFor(ModRecipes.SOUL_EXTRACTION_TYPE.get(), SoulExtractorTile.getRecipeInput(inventory), level);
        }
        if (SoulExtractorTile.hasRecipe(pEntity)) {
            pEntity.itemHandler.extractItem(0, 1, false);
            pEntity.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)((SoulExtractorRecipe)((RecipeHolder)recipe.get()).value()).output().copy().getItem(), pEntity.itemHandler.getStackInSlot(1).getCount() + 1));
            pEntity.resetProgress();
        }
    }

    public static RecipeInput getRecipeInput(final SimpleContainer inventory) {
        return new RecipeInput(){

            @NotNull
            public ItemStack getItem(int index) {
                return inventory.getItem(index).copy();
            }

            public int size() {
                return inventory.getContainerSize();
            }
        };
    }

    private static boolean hasRecipe(SoulExtractorTile entity) {
        Level level = entity.level;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = Optional.empty();
        if (level != null) {
            recipe = level.getRecipeManager().getRecipeFor(ModRecipes.SOUL_EXTRACTION_TYPE.get(), SoulExtractorTile.getRecipeInput(inventory), level);
            recipe.ifPresent(soulExtractorRecipeRecipeHolder -> {
                entity.maxProgress = (Integer)Config.extractor_speedtimer.get() * ((SoulExtractorRecipe)soulExtractorRecipeRecipeHolder.value()).time();
            });
        }
        return recipe.isPresent() && SoulExtractorTile.canInsertAmountIntoOutputSlot(inventory) && SoulExtractorTile.canInsertItemIntoOutputSlot(inventory, ((SoulExtractorRecipe)((RecipeHolder)recipe.get()).value()).output().copy().getItem().getDefaultInstance());
    }

    private static boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, ItemStack stack) {
        return inventory.getItem(1).getItem() == stack.getItem() || inventory.getItem(1).isEmpty();
    }

    private static boolean canInsertAmountIntoOutputSlot(SimpleContainer inventory) {
        return inventory.getItem(1).getMaxStackSize() > inventory.getItem(1).getCount();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider prov) {
        return this.saveWithFullMetadata(prov);
    }
}

