/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.networking;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.tarantel.chickenroost.block.tile.BreederTile;
import net.tarantel.chickenroost.block.tile.CollectorTile;
import net.tarantel.chickenroost.block.tile.FeederTile;
import net.tarantel.chickenroost.block.tile.RoostTile;
import net.tarantel.chickenroost.block.tile.SoulExtractorTile;
import net.tarantel.chickenroost.item.base.ChickenSeedBase;
import net.tarantel.chickenroost.networking.SetBreederAutoOutputPayload;
import net.tarantel.chickenroost.networking.SetCollectorRangePayload;
import net.tarantel.chickenroost.networking.SetCollectorRoostActivePayload;
import net.tarantel.chickenroost.networking.SetExtractorAutoOutputPayload;
import net.tarantel.chickenroost.networking.SetFeederRangePayload;
import net.tarantel.chickenroost.networking.SetFeederRoostActivePayload;
import net.tarantel.chickenroost.networking.SetFeederRoostSeedPayload;
import net.tarantel.chickenroost.networking.SetFeederRoundRobinPayload;
import net.tarantel.chickenroost.networking.SetFeederStackModePayload;
import net.tarantel.chickenroost.networking.SetRoostAutoOutputPayload;
import net.tarantel.chickenroost.networking.SetRoostNamePayload;

public final class ModNetworking {
    private ModNetworking() {
    }

    @SubscribeEvent
    public static void onRegisterPayloadHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(SetCollectorRoostActivePayload.TYPE, SetCollectorRoostActivePayload.STREAM_CODEC, ModNetworking::handleSetCollectorRoostActive);
        registrar.playToServer(SetCollectorRangePayload.TYPE, SetCollectorRangePayload.STREAM_CODEC, ModNetworking::handleSetCollectorRange);
        registrar.playToServer(SetFeederRangePayload.TYPE, SetFeederRangePayload.STREAM_CODEC, ModNetworking::handleSetFeederRange);
        registrar.playToServer(SetFeederRoostActivePayload.TYPE, SetFeederRoostActivePayload.STREAM_CODEC, ModNetworking::handleSetFeederRoostActive);
        registrar.playToServer(SetFeederRoostSeedPayload.TYPE, SetFeederRoostSeedPayload.STREAM_CODEC, ModNetworking::handleSetFeederRoostSeed);
        registrar.playToServer(SetFeederStackModePayload.TYPE, SetFeederStackModePayload.STREAM_CODEC, ModNetworking::handleSetFeederStackMode);
        registrar.playToServer(SetRoostAutoOutputPayload.TYPE, SetRoostAutoOutputPayload.STREAM_CODEC, ModNetworking::handleSetRoostAutoOutput);
        registrar.playToServer(SetExtractorAutoOutputPayload.TYPE, SetExtractorAutoOutputPayload.STREAM_CODEC, ModNetworking::handleSetExtractorAutoOutput);
        registrar.playToServer(SetBreederAutoOutputPayload.TYPE, SetBreederAutoOutputPayload.STREAM_CODEC, ModNetworking::handleSetBreederAutoOutput);
        registrar.playToServer(SetRoostNamePayload.TYPE, SetRoostNamePayload.STREAM_CODEC, ModNetworking::handleSetRoostName);
        registrar.playToServer(SetFeederRoundRobinPayload.TYPE, SetFeederRoundRobinPayload.STREAM_CODEC, ModNetworking::handleSetFeederRoundRobin);
    }

    private static void handleSetFeederStackMode(SetFeederStackModePayload msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player();
            ServerLevel level = player.serverLevel();
            BlockEntity be = level.getBlockEntity(msg.feederPos());
            if (be instanceof FeederTile) {
                FeederTile feeder = (FeederTile)be;
                feeder.setStackSendModeById(msg.mode());
            }
        });
    }

    private static void handleSetFeederRoundRobin(SetFeederRoundRobinPayload msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)patt0$temp;
            Level patt1$temp = sp.level();
            if (!(patt1$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt1$temp;
            BlockEntity be = level.getBlockEntity(msg.feederPos());
            if (!(be instanceof FeederTile)) {
                return;
            }
            FeederTile feeder = (FeederTile)be;
            feeder.setRoundRobinEnabled(msg.enabled());
        });
    }

    private static void handleSetRoostAutoOutput(SetRoostAutoOutputPayload msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player();
            ServerLevel level = player.serverLevel();
            BlockEntity be = level.getBlockEntity(msg.pos());
            if (be instanceof RoostTile) {
                RoostTile roost = (RoostTile)be;
                roost.setAutoOutputEnabled(msg.enabled());
            }
        });
    }

    private static void handleSetExtractorAutoOutput(SetExtractorAutoOutputPayload msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player();
            ServerLevel level = player.serverLevel();
            BlockEntity be = level.getBlockEntity(msg.pos());
            if (be instanceof SoulExtractorTile) {
                SoulExtractorTile roost = (SoulExtractorTile)be;
                roost.setAutoOutputEnabled(msg.enabled());
            }
        });
    }

    private static void handleSetBreederAutoOutput(SetBreederAutoOutputPayload msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player();
            ServerLevel level = player.serverLevel();
            BlockEntity be = level.getBlockEntity(msg.pos());
            if (be instanceof BreederTile) {
                BreederTile roost = (BreederTile)be;
                roost.setAutoOutputEnabled(msg.enabled());
            }
        });
    }

    private static void handleSetCollectorRoostActive(SetCollectorRoostActivePayload msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player();
            ServerLevel level = player.serverLevel();
            BlockEntity be = level.getBlockEntity(msg.collectorPos());
            if (be instanceof CollectorTile) {
                CollectorTile ct = (CollectorTile)be;
                ct.setRoostActive(msg.roostPos(), msg.active());
            }
        });
    }

    private static void handleSetCollectorRange(SetCollectorRangePayload msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player();
            ServerLevel level = player.serverLevel();
            BlockEntity be = level.getBlockEntity(msg.collectorPos());
            if (be instanceof CollectorTile) {
                CollectorTile ct = (CollectorTile)be;
                ct.setCollectRange(msg.range());
            }
        });
    }

    private static void handleSetFeederRange(SetFeederRangePayload msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player();
            ServerLevel level = player.serverLevel();
            BlockEntity be = level.getBlockEntity(msg.feederPos());
            if (be instanceof FeederTile) {
                FeederTile feeder = (FeederTile)be;
                feeder.setFeedRange(msg.range());
            }
        });
    }

    private static void handleSetFeederRoostActive(SetFeederRoostActivePayload msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player();
            ServerLevel level = player.serverLevel();
            BlockEntity be = level.getBlockEntity(msg.feederPos());
            if (be instanceof FeederTile) {
                FeederTile feeder = (FeederTile)be;
                if (msg.active()) {
                    feeder.addActiveRoost(msg.roostPos());
                } else {
                    feeder.removeActiveRoost(msg.roostPos());
                }
            }
        });
    }

    private static void handleSetRoostName(SetRoostNamePayload msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player();
            ServerLevel level = player.serverLevel();
            BlockEntity be = level.getBlockEntity(msg.pos());
            if (be instanceof RoostTile) {
                RoostTile roost = (RoostTile)be;
                roost.setCustomName(msg.name());
            }
        });
    }

    private static void handleSetFeederRoostSeed(SetFeederRoostSeedPayload msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player();
            ServerLevel level = player.serverLevel();
            BlockEntity be = level.getBlockEntity(msg.feederPos());
            if (!(be instanceof FeederTile)) {
                return;
            }
            FeederTile feeder = (FeederTile)be;
            if (msg.itemId() == null || msg.itemId().isEmpty()) {
                feeder.setPreferredSeed(msg.roostPos(), null);
                return;
            }
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)msg.itemId()));
            if (!ModNetworking.isAllowedGhostItemServer(item)) {
                feeder.setPreferredSeed(msg.roostPos(), null);
                return;
            }
            feeder.setPreferredSeed(msg.roostPos(), item);
        });
    }

    private static boolean isAllowedGhostItemServer(Item item) {
        return item instanceof ChickenSeedBase;
    }
}

